<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>PRODUCT REPORT</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <!-- <link rel="shortcut icon" type="image/x-icon" href="{{asset('frontend/img/vms (1).png')}}"> -->

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">

    <!-- FOR EXPORT -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">

        @extends('VMS.navbar')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>PRODUCT REPORT</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    <div class="page-btn">
                        <a href="ProductList" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Product</a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <!-- FOR FILTER -->
                                <!-- <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div> -->
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <!-- <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel" id="toEXCEL"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print" id="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div> -->
                        </div>


                        <div class="table-responsive">
                            <table class="table datanew" id="table">
                                <thead>
                                    <tr>
                                        <th>Options</th>
                                        <th style="display: none;">Rowid</th>
                                        <th>Sno</th>
                                        <th>Product Name</th>
                                        <th>Unit</th>
                                        <th>Brand</th>
                                        <th>Category</th>
                                        <th>Sub-Category</th>
                                        <th>Tax</th>
                                        <th>Discount</th>
                                        <th>Price</th>
                                        <th>Status</th>
                                        <th style="display: none;">Product Image</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($result as $index => $row)
                                    <tr>
                                        <td>
                                            <a class="me-3" href="ProductListView?mode=view&id={{$row['Rowid']}}&name={{$row['Product_Name']}}&item_id={{$row['Item_Id']}}&type_id={{$row['Type_Id']}}&size_id={{$row['Size_Id']}}&unit_id={{$row['Unit_Id']}}&brand_id={{$row['Brand_Id']}}&category_id={{$row['Category_Id']}}&sub_cat_id={{$row['Sub_Cat_Id']}}&tax_per={{$row['Tax_Per']}}&discount_per={{$row['Discount_Per']}}&price={{$row['Price']}}&status={{$row['Status']}}&description={{$row['Description']}}&prod_img={{$row['Prod_Img']}}&Reorder_Level={{$row['Reorder_Level']}}&Reorder_Qty={{$row['Reorder_Qty']}}">
                                                <img src="assets/img/icons/eye.svg" alt="View">
                                            </a>
                                            <?php
                                            $productEdit = Session::get('productEdit');
                                            ?>
                                            @if ($productEdit == "Y")
                                            <a class="me-3" href="ProductListEdit?mode=view&id={{$row['Rowid']}}&name={{$row['Product_Name']}}&item_id={{$row['Item_Id']}}&type_id={{$row['Type_Id']}}&size_id={{$row['Size_Id']}}&unit_id={{$row['Unit_Id']}}&brand_id={{$row['Brand_Id']}}&category_id={{$row['Category_Id']}}&sub_cat_id={{$row['Sub_Cat_Id']}}&tax_per={{$row['Tax_Per']}}&discount_per={{$row['Discount_Per']}}&price={{$row['Price']}}&status={{$row['Status']}}&description={{$row['Description']}}&prod_img={{$row['Prod_Img']}}&Reorder_Level={{$row['Reorder_Level']}}&Reorder_Qty={{$row['Reorder_Qty']}}">
                                                <img src="assets/img/icons/edit.svg" alt="Edit">
                                            </a>
                                            @endif
                                        </td>
                                        <td style="display: none;"> {{ $row ['Rowid'] }} </td>
                                        <td> {{ $index + 1 }} </td>
                                        <td> {{ $row ['Product_Name'] }} </td>
                                        <td>{{ isset($row['Unit_Id']) ? $row['Unit_Id'] : 'No data' }}</td>
                                        <td>{{ isset($row['Brand_Id']) ? $row['Brand_Id'] : 'No data' }}</td>
                                        <td>{{ isset($row['Category_Id']) ? $row['Category_Id'] : 'No data' }}</td>
                                        <td>{{ isset($row['Sub_Cat_Id']) ? $row['Sub_Cat_Id'] : 'No data' }}</td>
                                        <td>{{ isset($row['Tax_Per']) ? $row['Tax_Per'] : 'No data' }}</td>
                                        <td>{{ isset($row['Discount_Per']) ? $row['Discount_Per'] : 'No data' }}</td>
                                        <td>{{ isset($row['Price']) ? $row['Price'] : 'No data' }}</td>
                                        <td>{{ isset($row['Status']) ? $row['Status'] : 'No data' }}</td>
                                        <td style="display: none;">
                                            @if($row['Prod_Img'] !== "null")
                                            <a href="{{ $row['Prod_Img'] }}" class="mr-5 file-link" id="link2" name="filepath" target="_blank" title="{{ $row['Prod_Img'] }}">Image</a>
                                            @else
                                            --
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>

                            </table>


                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>


    <!-- PRINT -->
    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>

    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });

            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);

        }

        document.querySelector("#toEXCEL").addEventListener("click", function() {
            var table = document.querySelector("table");
            export_table_to_xlsx(table, "Product_List.xlsx");
        });
    </script>

</body>

</html>