<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>PRODUCT VIEW</title>

    <link rel="shortcut icon" type="image/x-icon" href="/assets/img/favicon.png">
    <link rel="stylesheet" href="/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="/assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="/assets/css/animate.css">
    <link rel="stylesheet" href="/assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="/assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="/assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="/assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="/assets/css/selectize.css">


    <style>
        .form-control {
            height: 15% !important;
        }
    </style>

</head>

<body>


    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        <!-- ============================================================================================== -->

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>PRODUCT DETAILS</h4>
                        <!-- <h6>Full details of a product</h6> -->
                    </div>
                    <a class="printimg" id="print">
                        <img src="/assets/img/icons/printer.svg" alt="print">
                    </a>
                </div>


                <form action="" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-lg-8 col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <!-- <div class="bar-code-view">
                                        <img src="{{asset('frontend/img/barcode1.png')}}" alt="barcode">
                                    </div> -->
                                    <div class="productdetails">
                                        <ul class="product-bar">
                                            <li>
                                                <h4>Product</h4>
                                                <h6>{{ request ('name') }}</h6>
                                            </li>
                                            <li>
                                                <h4>ITEM</h4>
                                                <h6>{{ request ('item_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>TYPE</h4>
                                                <h6>{{ request ('type_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>SIZE</h4>
                                                <h6>{{ request ('size_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Unit</h4>
                                                <h6>{{ request ('unit_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Brand</h4>
                                                <h6>{{ request ('brand_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Category</h4>
                                                <h6>{{ request ('category_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Sub Category</h4>
                                                <h6>{{ request ('sub_cat_id') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Description</h4>
                                                <h6>{{ request ('description') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Tax</h4>
                                                <h6>{{ request ('tax_per') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Discount</h4>
                                                <h6>{{ request ('discount_per') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Price</h4>
                                                <h6>{{ request ('price') }}</h6>
                                            </li>
                                            <li>
                                                <h4>Status</h4>
                                                <h6>{{ request ('status') }}</h6>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="slider-product-details">
                                        <div class="slider-product">
                                            <img src="{{ asset('VMS_Prod_img/' . request('prod_img')) }}" style="max-width: 100%; height: auto; align-items: center;">
                                            @if(request('prod_img') == 'No Image')
                                            <p>No Image Uploaded</p>
                                            @elseif(request('prod_img'))
                                            <p>Uploaded Image</p>
                                            @else
                                            <p>No Image Uploaded</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <script src="/assets/js/jquery-3.6.0.min.js"></script>
    <script src="/assets/js/selectize.js"></script>
    <script src="/assets/js/feather.min.js"></script>
    <script src="/assets/js/jquery.slimscroll.min.js"></script>
    <script src="/assets/js/jquery.dataTables.min.js"></script>
    <script src="/assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/js/bootstrap.bundle.min.js"></script>
    <script src="/assets/plugins/select2/js/select2.min.js"></script>
    <script src="/assets/js/moment.min.js"></script>
    <script src="/assets/js/bootstrap-datetimepicker.min.js"></script>
    <script src="/assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="/assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="/assets/plugins/fileupload/fileupload.min.js"></script>
    <script src="/assets/js/script.js"></script>
    <script src="/assets/plugins/fileupload/fileupload.min.js"></script>


    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>
    <!-- SELECTED PRODUCT SHOWN IN INPUT BOX -->
    <script>
        $(document).ready(function() {
            // Change event for all dropdowns with the class "select"
            $(".select").change(function() {
                updateProductName();
            });

            // Function to update PRODUCT NAME based on selected options
            function updateProductName() {
                var itemText = $(".itemDropdown option:selected").text();
                var typeName = $(".typeDropdown option:selected").text();
                var sizeName = $(".sizeDropdown option:selected").text();

                // Filter out the "Choose Category" option
                var selectedOptions = [itemText, typeName, sizeName].filter(option => option !== 'Choose Category');

                // Concatenate selected options with " | " separator
                var result = selectedOptions.filter(Boolean).join('  ');

                // Set the result as the value of the correct input field (update the ID if needed)
                $("#product_name").val(result);
            }
        });
    </script>


    <!-- .00 for Tax & Price -->
    <script>
        $(document).ready(function() {
            // Attach an event listener to the DISCOUNT input field
            $("#discountInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Attach an event listener to the PRICE input field
            $("#priceInput").on('blur', function() {
                formatDecimalInput($(this));
            });

            // Function to format input as a decimal with two decimal places
            function formatDecimalInput(inputField) {
                // Get the entered value
                var inputValue = inputField.val();

                // Convert the value to a decimal with two decimal places
                var formattedValue = parseFloat(inputValue).toFixed(2);

                // Set the formatted value back to the input field
                inputField.val(formattedValue);
            }
        });
    </script>

    <!-- IMAGE -->
    <script>
        function previewImage() {
            var input = document.getElementById('prodImgInput');
            var preview = document.getElementById('preview');
            var previewContainer = document.getElementById('imagePreview');

            var file = input.files[0];

            if (file) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    previewContainer.style.display = 'block';
                };

                reader.readAsDataURL(file);

                // } else {
                //     preview.src = '';
                //     previewContainer.style.display = null;
                previewContainer.style.display = 'block';

                // Hide the img2 div
                document.querySelector('.img2').style.display = 'none';
            }
        }
    </script>

</body>

</html>