<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>PURCHASE</title>
    <!-- <link rel="icon" href="gplogofinal.png" type="png"> -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        #newRowTemplate td {
            width: 1.5%;
            padding: 8px;

        }

        #newRowTemplate .custom-form-group {
            margin-bottom: 0;
        }

        #newRowTemplate input {
            width: 10%;
        }

        #newRowTemplate select {
            width: 100%;
        }

        td .selectize-input {
            width: 190px !important;
            max-width: 90% !important;
            height: 28px !important;
            margin-right: -70px;
        }
    </style>
</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Purchase Entry</h4>
                        <!-- <h6>Add Purchase</h6> -->
                    </div>
                </div>
                <form action="purchaseSave" method="post">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-xl-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Supplier Name</label>
                                        <div class="row">
                                            <div class="col-lg-12 col-sm-12 col-12">
                                                <select class="" placeholder="select" id="Ledger" name="ledger_code" required>
                                                    <option value="">--SELECT--</option>
                                                    @foreach($decode as $decodes)
                                                    <option value="{{ $decodes['Ledger_Code'] }}">{{ $decodes['Ledger_Name'] }}
                                                    </option>
                                                    @endforeach
                                                </select>

                                            </div>
                                            <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                            <div class="add-icon">
                                                <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                            </div>
                                        </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Purchase No</label>
                                        <input type="text" value="{{$pono}}" name="purchaseNo" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Purchase Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="purchaseDate" placeholder="DD-MM-YYYY" class="datetimepicker" id="purchaseDateInput" readonly>
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Indent No</label>
                                        <input type="text" value="0" name="indentNo" readonly>

                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference No</label>
                                        <input type="text" value="" name="referenceNo" required>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference Date </label>
                                        <div class="input-groupicon">
                                            <input type="date" name="referenceDate" id="referenceDateInput" max="<?= date('Y-m-d'); ?>" required class="form-control">


                                            <!-- <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6 col-10">
                                    <!-- <div class="form-group">
                                        <label>Search Product. </label>
                                        <div class="input-groupicon">
                                            
                                            <input type="text" placeholder="Search Data..." id="searchBox">
                                        </div>
                                        <div class="addonset">

                                        </div>
                                    </div> -->
                                </div>
                                <div class="col-lg-2 col-sm-6 col-10 mb-1">
                                    <!-- <label>Add product</label>
                                    <div class="add-icon mt-2">
                                        <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                    </div> -->
                                </div>

                                <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                <div class="add-icon">
                                    <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                            </div> -->
                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table" id="table">
                                        <thead>
                                            <tr>
                                                <th>Product</th>
                                                <th>Quantity</th>
                                                <th>Price(₹) </th>
                                                <!-- <th>Grand Cost</th> -->
                                                <th>Disc </th>
                                                <!-- <th>Disc Cost </th> -->
                                                <th>Gross Cost </th>
                                                <th>Tax %</th>
                                                <!-- <th>Tax Amount</th> -->
                                                <th>Total Cost </th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <tr id="newRowTemplate">
                                                <td class="" style="display: none;">
                                                    <input type="hidden" value="" class="sno" name="sno[]">
                                                </td>

                                                <td>
                                                    <select name="productName[]" id="purchaseList" class="purchaseList mt-1 " onchange="updatePrice(this)">
                                                        <option value="">--select--</option>
                                                        @foreach($decode2 as $decodes2)
                                                        <option value="{{ $decodes2['Rowid'] }}|{{ $decodes2['Price'] }}|{{ $decodes2['unit_id'] }}|{{ $decodes2['Tax_Per'] }}|{{ $decodes2['discount_per'] }}">
                                                            {{$decodes2['Product_Name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:70px;" value="" class="qty-input" name="quantity[]">
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class=" purchase-input" name="productPrice[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">

                                                </td>
                                                <!-- <td id="grandCost" class="grandCost" style="display: none;">

                                                </td> -->
                                                <td style="display: none;">
                                                    <input type="hidden" name="grandCost[]" class="grandCost">
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="discount-input" name="dicount[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="discountCost[]" class="discountCost">

                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" name="GrossCost[]" class="GrossCost" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <!-- <td class="" style="display: none;">
                                                    <input type="hidden" name="GrossCost[]" class="GrossCost">

                                                </td> -->

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="tax-input" name="tax[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="taxCost[]" class="taxCost">

                                                </td>
                                                <td class="totalCost">0.00</td>
                                                <td style="display: none;">
                                                    <input type="hidden" name="totalCost[]" class="totalCost-input">

                                                </td>
                                                <td>
                                                    <a class="" onclick="deleteRow(this.closest('tr'))"><img src="assets/img/icons/delete.svg" alt="svg"></a>


                                                </td>
                                            </tr>
                                            @if ($message = Session::get('SuccessMsg'))
                                            <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif
                                            @if ($message = Session::get('errorMsg'))
                                            <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                                                {{$message}}

                                            </div>

                                            <script>
                                                // Automatically close the alert after 3 seconds
                                                setTimeout(function() {
                                                    var successAlert = document.getElementById('successAlert');
                                                    if (successAlert) {
                                                        successAlert.remove();
                                                    }
                                                }, 3000);
                                            </script>
                                            @endif


                                        </tbody>
                                    </table>
                                </div>
                            </div>




                            <div class="row">
                                <div class="add-icon mt-2">
                                    <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                                <div class="col-lg-12 float-md-right">
                                    <div class="total-order">
                                        <ul>
                                            <li>
                                                <h4>Order Tax</h4>
                                                <h5 class="totalTaxCost">₹ 0.00 (0.00%)</h5>
                                                <input type="hidden" name="totalTaxCost" class="totalTaxCost-input">

                                            </li>
                                            <li>
                                                <h4>Discount </h4>
                                                <h5 class="totalDiscountCost">₹ 0.00</h5>
                                                <input type="hidden" name="totalDiscountCost" class="totalDiscountCost-input">

                                            </li>
                                            <li>
                                                <h4>Shipping</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="text" class="w-50 ShippingCost" style="height:30px;" value="0" name="shippingCost" oninput="validateinput(this)" required>
                                                </div>
                                            </li>
                                            <li>
                                                <h4>TCS %</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="text" class="w-50 TCSCost" style="height:30px;" value="0" name="TCSCost" oninput="validateinput(this)" required>
                                                </div>
                                            </li>
                                            <li class="total">
                                                <h4>Grand Total</h4>
                                                <h5 class="totalGrandCost">₹ 0.00</h5>
                                                <input type="hidden" name="totalGrandCost" class="totalGrandCost-input">
                                                <input type="hidden" name="totalGrossCost" class="totalGrossCost-input">

                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Order Tax</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Discount</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Shipping</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="select">
                                                <option>Choose Status</option>
                                                <option>Completed</option>
                                                <option>Inprogress</option>
                                            </select>
                                        </div>
                                    </div> -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="remarks"></textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <!-- <a href="" class=" me-2">Submit</a> -->
                                    <input type="submit" value="Submit" class="btn btn-submit">
                                    <!-- <a href="" class="btn btn-cancel">Cancel</a> -->
                                </div>
                            </div>
                </form>
            </div>
        </div>
    </div>
    </div>
    </div>
    <!-- Modal for confirmation to delete -->
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Confirmation</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure, want to delete this row?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="cancel-btn" data-bs-dismiss="modal">NO</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">YES</button>
                </div>
            </div>
        </div>
    </div>

    <!-- minimum one row limit -->
    <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Minimum one row is required.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>

    <!-- add new rowa and avoid duplicate -->


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>

    <!-- VALIDATION INPUT PRICE AND ADD '.' -->
    <script>
        function validateinput(input) {
            input.value = input.value.replace(/[^0-9.]/g, '');
        }
    </script>

    <!-- // Function to avoild feature date select -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var referenceDateInput = document.getElementById('referenceDateInput');

            // Set the current date as the maximum allowed date
            referenceDateInput.max = new Date().toISOString().split('T')[0];

            // Set the initial value to the current date
            var currentDate = new Date();
            var dd = String(currentDate.getDate()).padStart(2, '0');
            var mm = String(currentDate.getMonth() + 1).padStart(2, '0');
            var yyyy = currentDate.getFullYear();
            let formattedCurrentDate = yyyy + '-' + mm + '-' + dd;
            referenceDateInput.value = formattedCurrentDate;

            // Listen for changes in the date input
            referenceDateInput.addEventListener('input', function() {
                var selectedDate = new Date(this.value);

                // If the selected date is in the future, reset the input value
                if (selectedDate > currentDate) {
                    this.value = '';
                }
            });
        });
    </script>


    <!-- function to add new row and remove duplicate -->
    <script>
        var selectedOptions = [];

        function addRow() {
            var table = document.getElementById("table");
            var newRow = table.insertRow(table.rows.length);
            newRow.innerHTML = document.getElementById("newRowTemplate").innerHTML;

            // Update the row count in the "sno" column
            updateRowCount();

            // Attach input event listener to the new row
            var newInputs = newRow.querySelectorAll(
                ".qty-input, .purchase-input, .discount-input, .tax-input"
            );
            newInputs.forEach(function(input) {
                input.addEventListener("input", function() {
                    updateGrandCost(newRow);
                });
            });

            // Initialize selectize for the new row
            var purchaseListSelect = $(newRow).find(".purchaseList");
            initializepurchaseListSelect(purchaseListSelect);

            // Hide the selected option in other rows
            purchaseListSelect.change(function() {
                var selectedOption = $(this).val();
                $(".purchaseList").not(this).find('option[value="' + selectedOption + '"]').remove();
            });
        }

        // Function to initialize the "purchaseList" select dropdown
        function initializepurchaseListSelect(selectElement) {
            selectElement.selectize({
                create: true,
                sortField: "text",
                dropdownParent: "body",
                onDropdownOpen: function($dropdown) {
                    // Set the width and height of the dropdown
                    $dropdown.css({
                        width: "200px", // Adjust the width as needed
                        height: "150px", // Adjust the height as needed
                        overflow: "auto", // Use 'auto' to enable scrolling if content exceeds the height
                    });
                },
            });
        }
        addRow();

        function updateRowCount() {
            var table = document.getElementById('table');
            var rows = table.getElementsByTagName('tr');

            for (var i = 1; i < rows.length; i++) {
                var row = rows[i];
                var snoCell = row.querySelector('.sno');
                if (snoCell) {
                    snoCell.value = i - 1;
                }
            }
        }
        updateRowCount();
        // Event listener for the "Add Row" button
        document.getElementById('addRowBtn').addEventListener('click', addRow);
    </script>




    <!-- grand cost calculation -->
    <script>
        function updatePrice(selectElement) {
            var priceInput = selectElement.closest('tr').querySelector('.purchase-input');
            // var qtyInput = selectElement.closest('tr').querySelector('.qty-input');
            var discountInput = selectElement.closest('tr').querySelector('.discount-input');
            var taxInput = selectElement.closest('tr').querySelector('.tax-input');
            var selectedValue = selectElement.value;
            var rowidAndPrice = selectedValue.split('|');
            var price = parseFloat(rowidAndPrice[1]) || 0;
            // var qty = parseFloat(rowidAndPrice[2]) || 0;
            var disc = parseFloat(rowidAndPrice[4]) || 0;
            var tax = parseFloat(rowidAndPrice[3]) || 0;
            priceInput.value = price;
            // qtyInput.value = qty;
            discountInput.value = disc;
            taxInput.value = tax;
            updateGrandCost(selectElement.closest('tr'));

        }



        function updateGrandCost(row) {
            var qty = parseFloat(row.querySelector('.qty-input').value) || 0;
            var purchase = parseFloat(row.querySelector('.purchase-input').value) || 0;
            var discount = parseFloat(row.querySelector('.discount-input').value) || 0;
            var tax = parseFloat(row.querySelector('.tax-input').value) || 0;
            var grandCost = qty * purchase;
            var discountCost = grandCost * (discount / 100);
            var grandCostElement = row.querySelector('.grandCost');
            var discountElement = row.querySelector('.discountCost');
            var grossElement = row.querySelector('.GrossCost');
            var taxElement = row.querySelector('.taxCost');
            var totalElement = row.querySelector('.totalCost');




            if (grandCostElement) {
                grandCostElement.textContent = grandCost.toFixed(2);


            }
            if (grandCostElement) {
                grandCostElement.value = grandCost.toFixed(2);
            }
            if (discountElement) {
                discountElement.value = discountCost.toFixed(2);
            } else {
                discountCost = 0;
            }

            let grossCost = grandCost - discountCost;
            if (grossElement) {
                grossElement.value = grossCost.toFixed(2);
            } else {
                grossCost = 0;
            }

            let taxCost = (tax / 100) * grossCost;
            if (taxElement) {
                taxElement.value = taxCost.toFixed(2);
            } else {
                taxCost = 0;
            }
            let totalCost = grossCost + taxCost;
            if (totalElement) {
                totalElement.textContent = totalCost.toFixed(2);
            } else {
                totalCost = 0;
            }

            var totalcostInput = row.querySelector('.totalCost-input');
            if (totalcostInput) {
                totalcostInput.value = totalCost.toFixed(2);
            } else {
                totalCost = 0;
            }

            updateTotalCost();
        }

        function updateTotalCost() {
            var taxCostElements = document.querySelectorAll('.taxCost');
            var taxCost = 0;
            var discountCostElements = document.querySelectorAll('.discountCost');
            var discountCost = 0;
            var totalCostElements = document.querySelectorAll('.totalCost');
            var totalGrandCost = 0;
            var totalGrossCostElements = document.querySelectorAll('.GrossCost');
            var totalGrossCost = 0;

            taxCostElements.forEach(function(element) {
                taxCost += parseFloat(element.value) || 0;
            });

            discountCostElements.forEach(function(element) {
                discountCost += parseFloat(element.value) || 0;
            });

            totalCostElements.forEach(function(element) {
                totalGrandCost += parseFloat(element.textContent) || 0;
            });

            totalGrossCostElements.forEach(function(element) {
                totalGrossCost += parseFloat(element.value) || 0;
            });

            var shippingInput = document.querySelector('.ShippingCost');
            var shippingCost = parseFloat(shippingInput.value) || 0;

            var totalGrossElement = document.querySelector('.totalGrossCost-input');
            if (totalGrossElement) {
                totalGrossElement.value = totalGrossCost.toFixed(2);
            }

            var totaltaxElement = document.querySelector('.totalTaxCost');
            if (totaltaxElement) {
                totaltaxElement.textContent = '₹ ' + taxCost.toFixed(2);
                var totaltaxElementInput = document.querySelector('.totalTaxCost-input');
                totaltaxElementInput.value = taxCost.toFixed(2);
            }

            var totalDiscountElement = document.querySelector('.totalDiscountCost');
            if (totalDiscountElement) {
                totalDiscountElement.textContent = '₹ ' + discountCost.toFixed(2);
                var totalDiscountElementInput = document.querySelector('.totalDiscountCost-input');
                totalDiscountElementInput.value = discountCost.toFixed(2);
            }

            var tcsInput = document.querySelector('.TCSCost');
            var tcsCost = parseFloat(tcsInput.value) || 0;



            var totalGrandElement = document.querySelector('.totalGrandCost');
            if (totalGrandElement) {

                var grandTotal = shippingCost + totalGrandCost;

                var tcsCost1 = (grandTotal * tcsCost) / 100;

                var grandTotal1 = tcsCost1 + grandTotal;

                totalGrandElement.textContent = '₹ ' + grandTotal1.toFixed(2);
                var totalGrandElementInput = document.querySelector('.totalGrandCost-input');
                totalGrandElementInput.value = grandTotal1.toFixed(2);
            }

            var shippingInput = document.querySelector('.ShippingCost');
            if (shippingInput) {
                shippingInput.addEventListener('input', function() {
                    updateTotalCost(); // Call the updateTotalCost function when the input changes
                });
            }
            var tcsInput = document.querySelector('.TCSCost');
            if (tcsInput) {
                tcsInput.addEventListener('input', function() {
                    updateTotalCost(); // Call the updateTotalCost function when the input changes
                });
            }
        }


        // Declare a variable to store the row to be deleted
        let rowToDelete;

        // Function to handle row deletion
        function deleteRow(row) {
            // Store the row to be deleted
            rowToDelete = row;

            let rowCount = $('#table tr').length;

            // Show the confirmation modal based on the row count
            if (rowCount > 3) {
                $('#deleteConfirmationModal').modal('show');
            } else {
                $('#minimumRowModal').modal('show');
            }
        }


        // Handle the click event for the "Delete" button in the modal
        $('#confirmDeleteBtn').click(function() {
            // Get the value of the deleted row's select element
            var deletedValue = rowToDelete.querySelector('.purchaseList').value;

            // Remove the deleted value from the selectedOptions array
            var index = selectedOptions.indexOf(deletedValue);
            if (index !== -1) {
                selectedOptions.splice(index, 1);
            }

            // Remove the row from the table
            rowToDelete.parentNode.removeChild(rowToDelete);

            // Hide the confirmation modal
            $('#deleteConfirmationModal').modal('hide');

            // Call the updateTotalCost function after deleting a row
            updateTotalCost();
        });



        var newRows = document.querySelectorAll('.qty-input, .purchase-input, .discount-input, .tax-input , .purchaseList');
        newRows.forEach(function(newRow) {
            newRow.addEventListener('input', function() {
                updateGrandCost(newRow.closest('tr'));
            });
        });

        $(document).ready(function() {

            $('#newRowTemplate').hide();

            $('#Ledger').selectize({
                create: true,
                sortField: 'text'
            });


        });
    </script>


    <script>
        // Function to format the current date as DD-MM-YYYY
        function getCurrentDate() {
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0');
            var yyyy = today.getFullYear();
            return dd + '-' + mm + '-' + yyyy;
        }

        // Set default values for datetimepicker inputs
        document.getElementById('purchaseDateInput').value = getCurrentDate();
        // document.getElementById('referenceDateInput').value = getCurrentDate();
    </script>

    <!-- SEARCH IN TABLE -->
    <!-- <script>
        $(document).ready(function() {
            $("#searchBox").on("keyup", function() {
                var value = $(this).val().toLowerCase();
                var matches = $("#table tbody tr").filter(function() {
                    return $(this).text().toLowerCase().indexOf(value) > -1;
                });

                if (value === "") {
                    // $("#searchCountTest").text("");
                    // $("#entryCountTest").show(); // Show the entry count
                    $("#table tbody tr").toggle(true);

                    // updateRowsPerPage(); // Call the function to reset displayed rows
                } else {
                    // $("#entryCountTest").hide(); // Hide the entry count
                    // Show the search count and hide rows that don't match the search criteria
                    // $("#searchCountTest").text(matches.length + " result(s) found");
                    matches.toggle(true);
                    $("#table tbody tr").not(matches).toggle(false);


                }
            });
        });
    </script> -->


    <!-- ALERT MESSAGE -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 10000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 10000);
    </script>
    @endif



    @endsection
</body>

</html>