<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>VMS</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/plugins/owlcarousel/owl.carousel.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        table thead {
            border-top: 1px solid gray !important;
            border-bottom: 1px solid gray !important;

        }

        table {
            font-size: 12px;
        }

        #details {
            display: flex !important;
            /* width: 200% !important; */

        }

        @media print {
            .header {
                margin: 0;
                visibility: hidden;
            }

            .content {
                text-align: center;
                font-size: 18px;
                color: #333;
            }

            #page-title {
                visibility: hidden;
            }

            #print {
                visibility: hidden;
            }

            #head-text {
                text-align: center;
            }
        }
    </style>


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content" id="printableArea">
                <div class="d-flex justify-content-between">
                    <div class="page-title " id="page-title">
                        <h4>Purchase View</h4>

                    </div>
                    <div>
                        <a class="printimg" id="print">
                            <img src="/assets/img/icons/printer.svg" alt="print">
                        </a>
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-lg-12 col-sm-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="fw-bold " id="head-text">Purchase Order</h6>
                        </div>
                        <div class="card-body">

                            <div class="d-md-flex col-sm-12" id="details">
                                <div class="col-sm-4">
                                    <p class="fw-bold" style="font-size: 12px;">


                                        <?php
                                        $compAddress = Session::get('CompanyAddress');
                                        $CompanyCode = Session::get('CompanyCode');
                                        $CompanyGST = Session::get('CompanyGST');
                                        $compPANNo = Session::get('compPANNo');
                                        $companyName = Session::get('CompName');
                                        ?>

                                        {{$companyName}}
                                    </p>
                                    <p style="font-size: 12px;">


                                        {{$compAddress}}
                                    </p>
                                </div>
                                <div class="ms-3 mt-4 pt-3 col-sm-7" style="border-left: 1px solid #000;">
                                    @if ($CompanyCode == 2)
                                    <img src="assets/img/companylogo/alamelu.jpeg" style="max-width: 20%; margin-top: -20%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 3)
                                    <img src="assets/img/companylogo/irulappa.jpeg" style="max-width: 20%; margin-top: -20%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 1)
                                    <img src="assets/img/companylogo/gainup.jpeg" style="max-width: 20%; margin-top: -20%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 8)
                                    <img src="assets/img/companylogo/techno tech.jpeg" style="max-width: 20%; margin-top: -20%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @elseif ($CompanyCode == 9)
                                    <img src="assets/img/companylogo/richworld.jpeg" style="max-width: 20%; margin-top: -20%; height: auto; float: right; margin-left: 10px;" alt="img">
                                    @endif
                                    <table class="ms-2">
                                        <tbody>
                                            <tr>
                                                <td>PAN NO </td>
                                                <td>:</td>
                                                <td> {{$compPANNo}}</td>
                                            </tr>
                                            <tr>
                                                <td>GST NO </td>
                                                <td> : </td>
                                                <td>
                                                    {{$CompanyGST}}
                                                </td>
                                            </tr>
                                            <!-- <tr>
                                                    <td>PHONE</td>
                                                    <td>:</td>
                                                    <td> 9876543210</td>
                                                </tr> -->
                                            <!-- <tr>
                                                    <td>EMAIL</td>
                                                    <td>:</td>
                                                    <td> INFO@gainup.in</td>
                                                </tr> -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>


                            <div class="d-md-flex mt-4 col-sm-12" id="details">
                                <div class="col-sm-4">
                                    <p class="fw-bold" style="font-size: 12px;">
                                        <!-- SAKTHI INDUSTRIES INDIA PVT LTD -->
                                        {{ request('Ledger_Name') }}


                                    </p>
                                    <p style="font-size: 12px;">
                                        <!-- 13/341,DINDIGUL-BATLAGUNDU HIGHWAY, <br>SITHARAEVU VILLAGE,OTTUPATTI(PO),
                                            <br>DINDIGUL(DT),TAMILNADU
                                            <br>DINDIGUL-624 708 <br>
                                            INDIA -->
                                        {{ request('Ledger_Address') }}

                                    </p>
                                </div>

                                <div class="ms-3 mt-4 pt-3 col-sm-7" style="border-left: 1px solid #000;">
                                    <!-- <p class="fw-bold">GAINUP INDUSTRIES INDIA PVT LTD</p> -->
                                    <table class="ms-2">
                                        <tbody>
                                            <tr>
                                                <td>PO NO </td>
                                                <td> :</td>
                                                <td> {{ request('pono') }} </td>
                                            </tr>
                                            <tr>
                                                <td>PO Date</td>
                                                <td> :</td>
                                                <td>{{ \Carbon\Carbon::parse(request('PODate'))->format('Y-m-d') }}</td>


                                            </tr>
                                            <tr>
                                                <td>GST No</td>
                                                <td> :</td>
                                                @foreach ($decode as $decodes)
                                                @php
                                                $GstNo = $decodes['GST_No'];
                                                @endphp
                                                @endforeach
                                                <td>{{$GstNo}}</td>


                                            </tr>
                                            <!-- <tr>
                                                    <td>Req Date</td>
                                                    <td> :</td>
                                                    <td> {{ request('RefNo') }} </td>
                                                </tr>
                                                <tr>
                                                    <td>Print Out Date</td>
                                                    <td> :</td>
                                                    <td>{{ request('RefDate') }}  </td>
                                                </tr> -->
                                        </tbody>
                                    </table>


                                </div>


                            </div>


                        </div>
                    </div>

                </div>


            </div>
            <div class="productdetails">
                <!-- <table class="table">
                        <thead>
                            <th>ITEM</th>
                            <th>DESCRIPTION</th>
                            <th>UNIT COST</th>
                            <th>QTY/HR RATE</th>
                            <th>TOTAL</th>
                        </thead>
                        <tbody>
                            <tr>
                                <td>{{ request('product_name') }}</td>
                                <td>test</td>
                                <td>{{ request('qty') }}</td>
                                <td>{{ request('rate') }}</td>
                                <td>{{ request('net_amt') }}</td>
                            </tr>
                        </tbody>
                    </table> -->

                <div class="row">
                    <div class="table-responsive">
                        <table class="table" id="table">
                            <thead>
                                <tr>

                                    <th>Product</th>

                                    <th>Quantity</th>
                                    <th>Price(₹) </th>
                                    <th>Discount </th>

                                    <th>Tax %</th>

                                    <th>Total Cost </th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($decode as $decodes)
                                <tr id="newRowTemplate">
                                    <td class="form-group">
                                        {{$decodes['Product_Name']}}
                                    </td>
                                    <td class="form-group">
                                        {{$decodes['Qty']}}

                                    </td>
                                    <td class="form-group">
                                        {{$decodes['Rate']}}


                                    <td class="form-group">
                                        {{$decodes['Disc_Per']}}
                                    </td>


                                    <td class="form-group">
                                        {{$decodes['Tax_Per']}}
                                    </td>

                                    <td class="totalCost">
                                        {{$decodes['Net_Amt']}}

                                    </td>

                                </tr>

                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-11 float-md-right">
                        <div class="total-order">
                            <ul>
                                <li>
                                    <h4>Order Tax</h4>
                                    <h5 class="totalTaxCost">₹ {{$decodes['TaxAmt']}} </h5>

                                </li>
                                <li>
                                    <h4>Discount </h4>
                                    <h5 class="totalDiscountCost">₹ {{$decodes['DisAmt']}}</h5>


                                </li>
                                <li>
                                    <h4>Shipping</h4>
                                    <h5>{{$decodes['ShipAmt']}}</h5>
                                </li>
                                <li class="total">
                                    <h4>Grand Total</h4>
                                    <h5 class="totalGrandCost">₹ {{$decodes['NetAmt']}}</h5>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/owlcarousel/owl.carousel.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/script.js"></script>


    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>



    @endsection
</body>

</html>