<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>VMS</title>
    <!-- <link rel="icon" href="gplogofinal.png" type="png"> -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        #newRowTemplate td {
            width: 1.5%;
            padding: 8px;

        }

        #newRowTemplate .custom-form-group {
            margin-bottom: 0;
        }

        #newRowTemplate input {
            width: 10%;
        }

        #newRowTemplate select {
            width: 100%;
        }

        td .selectize-input {
            width: 120px !important;
            /* Adjust the width as needed */
            max-width: 90% !important;
            height: 28px !important;
        }

        .selectize-dropdown-content {
            color: black !important;
        }
    </style>
</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Edit Purchase </h4>
                        <!-- <h6>Add/Update Purchase</h6> -->
                    </div>
                </div>
                <form action="purchasedelete" method="post">
                    @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-3 col-xl-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Supplier Name</label>
                                        <div class="row">
                                            <input type="text" name="" id="" value="{{ request('Ledger_Name') }}" readonly>
                                            <div class="col-lg-12 col-sm-12 col-12">

                                            </div>
                                            <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                            <div class="add-icon">
                                                <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                            </div>
                                        </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Purchase No.</label>
                                        <input type="text" value="{{ request('pono') }}" name="purchaseNo" readonly>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Purchase Date </label>

                                        <input type="text" name="referenceNo" value="{{ \Carbon\Carbon::parse(request('PODate'))->format('Y-m-d') }}" readonly>

                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Indent NO</label>
                                        <input type="text" value="0" name="indentNo" readonly>

                                    </div>
                                </div>
                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference No.</label>
                                        <input type="text" name="referenceNo" value="{{ request('RefNo') }}">
                                    </div>
                                </div>

                                <div class="col-lg-3 col-sm-6 col-12">
                                    <div class="form-group">
                                        <label>Reference Date </label>
                                        <div class="input-groupicon">
                                            <input type="text" name="referenceDate" id="referenceDateInput" value=" {{ \Carbon\Carbon::parse(request('RefDate'))->format('Y-m-d') }}" readonly>

                                            <!-- 
                                            <div class="addonset">
                                                <img src="assets/img/icons/calendars.svg" alt="img">
                                            </div> -->
                                        </div>
                                        <!-- <input type="text" name="referenceNo" value="{{ request('RefDate') }}"> -->

                                    </div>
                                </div>
                                <div class="col-lg-4 col-sm-6 col-10">
                                    <!-- <div class="form-group">
                                        <label>Search Product. </label>
                                        <div class="input-groupicon">
                                            
                                            <input type="text" placeholder="Search Data..." id="searchBox">
                                        </div>
                                        <div class="addonset">

                                        </div>
                                    </div> -->
                                </div>
                                <div class="col-lg-2  col-sm-6 col-10 mb-1">
                                    <!-- <label>Add product</label>
                                    <div class="add-icon mt-2">
                                        <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                    </div> -->
                                </div>

                                <!-- <div class="col-lg-2 col-sm-2 col-2 ps-0">
                                <div class="add-icon">
                                    <a href="javascript:void(0);"><img src="assets/img/icons/plus1.svg" alt="img"></a>
                                </div>
                            </div> -->
                            </div>
                            <div class="row">
                                <div class="table-responsive">
                                    <table class="table" id="table">
                                        <thead>
                                            <tr>
                                                <th>Product</th>
                                                <th>Quantity</th>
                                                <th>Price(₹) </th>
                                                <!-- <th>Grand Cost</th> -->
                                                <th>Disc </th>
                                                <!-- <th>Disc Cost </th> -->
                                                <!-- <th>Gross Cost </th> -->
                                                <th>Tax %</th>
                                                <!-- <th>Tax Amount</th> -->
                                                <th>Total Cost </th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <tr id="newRowTemplate">

                                                <td class="" style="display: none;">
                                                    <input type="hidden" value="" class="sno" name="sno[]">
                                                </td>

                                                <td>
                                                    <select name="productName[]" id="purchaseList" class="purchaseList mt-1 " onchange="updatePrice(this)">
                                                        <option value="">--select--</option>
                                                        @foreach($decode2 as $decodes2)
                                                        <option value="{{ $decodes2['Rowid'] }}|{{ $decodes2['Price'] }}|{{ $decodes2['unit_id'] }}|{{ $decodes2['Tax_Per'] }}|{{ $decodes2['discount_per'] }}">{{$decodes2['Product_Name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:70px;" value="" class="qty-input" name="quantity[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">

                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class=" purchase-input" name="productPrice[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">

                                                </td>

                                                <td style="display: none;">
                                                    <input type="hidden" name="grandCost[]" class="grandCost">
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="discount-input" name="dicount[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="discountCost[]" class="discountCost">

                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="GrossCost[]" class="GrossCost">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="" class="tax-input" name="tax[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="taxCost[]" class="taxCost">

                                                </td>
                                                <td class="totalCost">0.00</td>
                                                <td style="display: none;">
                                                    <input type="hidden" name="totalCost[]" class="totalCost-input">

                                                </td>
                                                <td>
                                                    <a class="" onclick="deleteRow(this.closest('tr'))"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                </td>
                                            </tr>

                                            @foreach ($decode as $decodes)
                                            <tr id="newRow">

                                                <td class="" style="display: none;">
                                                    <input type="hidden" value="{{$decodes['SNo']}}" class="sno" name="sno[]">
                                                    <input type="hidden" value="{{$decodes['MasteR_ID']}}" class="sno" name="MasterID[]">
                                                    <input type="hidden" value="{{$decodes['MasteR_ID']}}" class="sno" name="MasterIDMaster">
                                                    <input type="hidden" name="ledger_code" id="" value="{{ $decodes['Supplier_Code'] }}">
                                                    <input type="hidden" name="productName[]" id="" class="purchaseList" value="{{ $decodes['Prod_ID'] }}|{{ $decodes['Rate'] }}">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:170px;" name="" value="{{$decodes['Product_Name']}}" class="" readonly>



                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style="height: 30px !important; width:70px;" value="{{$decodes['Qty']}}" class="qty-input" name="quantity[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">

                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="{{$decodes['Rate']}}" class=" purchase-input" name="productPrice[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">

                                                </td>
                                                <!-- <td id="grandCost" class="grandCost" style="display: none;">

                                                </td> -->
                                                <td style="display: none;">
                                                    <input type="hidden" name="grandCost[]" class="grandCost" value="{{$decodes['Allot_Amt']}}">
                                                </td>
                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="{{$decodes['Disc_Per']}}" class="discount-input" name="dicount[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="discountCost[]" class="discountCost" value="{{$decodes['Disc_Amt']}}">

                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="GrossCost[]" class="GrossCost" value=" {{$decodes['Grs_Amt']}}">

                                                </td>

                                                <td class="form-group">
                                                    <input type="text" style=" height: 30px !important; width:70px;" value="{{$decodes['Tax_Per']}}" class="tax-input" name="tax[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '');">
                                                </td>
                                                <td class="" style="display: none;">
                                                    <input type="hidden" name="taxCost[]" class="taxCost" value="{{$decodes['Tax_Amt']}}">

                                                </td>
                                                <td class="totalCost">
                                                    {{$decodes['Net_Amt']}}

                                                </td>
                                                <td style="display: none;">
                                                    <input type="hidden" name="totalCost[]" value=" {{$decodes['Net_Amt']}}" class="totalCost-input">

                                                </td>
                                                <td>
                                                    <a class="" onclick="deleteRow(this.closest('tr'))"><img src="assets/img/icons/delete.svg" alt="svg"></a>
                                                </td>
                                            </tr>
                                            @endforeach




                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="row">
                                <div class="add-icon mt-2">
                                    <a href="javascript:void(0);" id="addRowBtn"><img src="assets/img/icons/plus1.svg" alt="img"></a>

                                </div>
                                <div class="col-lg-12 float-md-right">
                                    <div class="total-order">
                                        <ul>
                                            <li>
                                                <h4>Order Tax</h4>
                                                <h5 class="totalTaxCost">₹ {{$decodes['TaxAmt']}} </h5>
                                                <input type="hidden" value="{{$decodes['TaxAmt']}}" name="totalTaxCost" class="totalTaxCost-input">

                                            </li>
                                            <li>
                                                <h4>Discount </h4>
                                                <h5 class="totalDiscountCost">₹ {{$decodes['DisAmt']}}</h5>
                                                <input type="hidden" name="totalDiscountCost" class="totalDiscountCost-input" value="{{$decodes['DisAmt']}}">

                                            </li>
                                            <li>
                                                <h4>Shipping</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="text" class="w-50 ShippingCost" style="height:30px;" value="{{$decodes['ShipAmt']}}" name="shippingCost" required>
                                                </div>
                                            </li>
                                            <li>
                                                <h4>TCS %</h4>
                                                <div class="form-group d-flex justify-content-end mt-3 ">
                                                    <input type="text" class="w-50 TCSCost" style="height:30px;" value="{{$decodes['TCS_Per']}}" name="TCSCost" required>
                                                </div>
                                            </li>
                                            <li class="total">
                                                <h4>Grand Total</h4>
                                                <h5 class="totalGrandCost">₹ {{$decodes['NetAmt']}}</h5>
                                                <input type="hidden" name="totalGrandCost" class="totalGrandCost-input" value="{{$decodes['NetAmt']}}">
                                                <input type="hidden" name="totalGrossCost" class="totalGrossCost-input" value="{{$decodes['Grs_Amt']}}">
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Order Tax</label>
                                            <input type="text">
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Discount</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Shipping</label>
                                            <input type="text">
                                        </div>
                                    </div> -->
                                <!-- <div class="col-lg-3 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select class="select">
                                                <option>Choose Status</option>
                                                <option>Completed</option>
                                                <option>Inprogress</option>
                                            </select>
                                        </div>
                                    </div> -->
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea class="form-control" name="remarks" required>{{ request('Remarks') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <!-- <a href="" class=" me-2">Submit</a> -->
                                    <input type="submit" value="Submit" class="btn btn-submit">
                                    <a href="purchaselist.html" class="btn btn-cancel">Cancel</a>
                                </div>
                            </div>
                </form>
            </div>
        </div>
    </div>
    </div>
    </div>


    <!-- error replay  -->
    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif
    @if ($message = Session::get('MasterApiError'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>
    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>

    @endif

    <!-- eror reply modal -->

    <!-- Modal for confirmation to delete -->
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Confirmation</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this row?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" id="cancel-btn" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirmDeleteBtn">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <!-- minimum one row limit -->
    <div class="modal fade" id="minimumRowModal" tabindex="-1" role="dialog" aria-labelledby="minimumRowModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="minimumRowModalLabel">Minimum Row Requirement</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    At least one row is required. You cannot delete the last row.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>

    <!--   modal end -->



    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>

    <!-- // Function to avoid feature date -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var referenceDateInput = document.getElementById('referenceDateInput');

            // Set the current date as the maximum allowed date
            referenceDateInput.max = new Date().toISOString().split('T')[0];

            // Listen for changes in the date input
            referenceDateInput.addEventListener('input', function() {
                var selectedDate = new Date(this.value);
                var currentDate = new Date();

                // If the selected date is in the future, reset the input value
                if (selectedDate > currentDate) {
                    this.value = '';
                }
            });
        });
    </script>

    <!-- ************************* delete confirmation *****************************************  -->
    <script>
        // Declare a variable to store the row to be deleted
        let rowToDelete;

        // Function to handle row deletion
        function deleteRow(row) {
            // Store the row to be deleted
            rowToDelete = row;

            let rowCount = $('#table tr').length;

            // Show the confirmation modal based on the row count
            if (rowCount > 3) {
                $('#deleteConfirmationModal').modal('show');
            } else {
                $('#minimumRowModal').modal('show');
            }
        }


        // Handle the click event for the "Delete" button in the modal
        $('#confirmDeleteBtn').click(function() {
            // Get the value of the deleted row's select element
            var deletedValue = rowToDelete.querySelector('.purchaseList').value;

            // Remove the deleted value from the selectedOptions array
            var index = selectedOptions.indexOf(deletedValue);
            if (index !== -1) {
                selectedOptions.splice(index, 1);
            }

            // Remove the row from the table
            rowToDelete.parentNode.removeChild(rowToDelete);

            // Hide the confirmation modal
            $('#deleteConfirmationModal').modal('hide');

            // Call the updateTotalCost function after deleting a row
            updateTotalCost();
        });
    </script>

    <!-- add new rowa and avoid duplicate -->

    <script>
        var selectedOptions = [];

        function addRow() {
            var table = document.getElementById("table");
            var newRow = table.insertRow(table.rows.length);
            newRow.innerHTML = document.getElementById("newRowTemplate").innerHTML;

            // Update the row count in the "sno" column
            updateRowCount();

            // Attach input event listener to the new row
            var newInputs = newRow.querySelectorAll(
                ".qty-input, .purchase-input, .discount-input, .tax-input"
            );
            newInputs.forEach(function(input) {
                input.addEventListener("input", function() {
                    updateGrandCost(newRow);
                });
            });

            // Initialize selectize for the new row
            var purchaseListSelect = $(newRow).find(".purchaseList");
            initializepurchaseListSelect(purchaseListSelect);

            // Hide the selected option in other rows
            purchaseListSelect.change(function() {
                var selectedOption = $(this).val();
                $(".purchaseList").not(this).find('option[value="' + selectedOption + '"]').remove();
            });
        }

        // Function to initialize the "purchaseList" select dropdown
        function initializepurchaseListSelect(selectElement) {
            selectElement.selectize({
                create: true,
                sortField: "text",
                dropdownParent: "body",
                onDropdownOpen: function($dropdown) {
                    // Set the width and height of the dropdown
                    $dropdown.css({
                        width: "200px", // Adjust the width as needed
                        height: "150px", // Adjust the height as needed
                        overflow: "auto", // Use 'auto' to enable scrolling if content exceeds the height
                    });
                },
            });
        }

        // Update the row count in the "sno" column for all rows
        function updateRowCount() {
            var table = document.getElementById('table');
            var rows = table.getElementsByTagName('tr');

            for (var i = 1; i < rows.length; i++) {
                var row = rows[i];
                var snoCell = row.querySelector('.sno');
                if (snoCell) {
                    snoCell.value = i - 1;
                }
            }
        }

        // Event listener for the "Add Row" button
        document.getElementById('addRowBtn').addEventListener('click', addRow);
    </script>




    <script>
        $(document).ready(function() {

            $('#newRowTemplate').hide();
            $('#Ledger').selectize({
                create: true,
                sortField: 'text'
            });

            $('.purchaseList1').selectize({
                create: true,
                sortField: 'text',
                readOnly: true // Add this line to make the select element readonly
            });




        });
    </script>


    <!-- grand cost calculation -->
    <script>
        function updatePrice(selectElement) {
            var priceInput = selectElement.closest('tr').querySelector('.purchase-input');
            // var qtyInput = selectElement.closest('tr').querySelector('.qty-input');
            var discountInput = selectElement.closest('tr').querySelector('.discount-input');
            var taxInput = selectElement.closest('tr').querySelector('.tax-input');
            var selectedValue = selectElement.value;
            var rowidAndPrice = selectedValue.split('|');
            var price = parseFloat(rowidAndPrice[1]) || 0;
            // var qty = parseFloat(rowidAndPrice[2]) || 0;
            var disc = parseFloat(rowidAndPrice[4]) || 0;
            var tax = parseFloat(rowidAndPrice[3]) || 0;
            priceInput.value = price;
            // qtyInput.value = qty;
            discountInput.value = disc;
            taxInput.value = tax;
            updateGrandCost(selectElement.closest('tr'));
        }


        function updateGrandCost(row) {
            var qty = parseFloat(row.querySelector('.qty-input').value) || 0;
            var purchase = parseFloat(row.querySelector('.purchase-input').value) || 0;
            var discount = parseFloat(row.querySelector('.discount-input').value) || 0;
            var tax = parseFloat(row.querySelector('.tax-input').value) || 0;
            var grandCost = qty * purchase;
            var discountCost = grandCost * (discount / 100);
            var grandCostElement = row.querySelector('.grandCost');
            var discountElement = row.querySelector('.discountCost');
            var grossElement = row.querySelector('.GrossCost');
            var taxElement = row.querySelector('.taxCost');
            var totalElement = row.querySelector('.totalCost');
            if (grandCostElement) {
                grandCostElement.textContent = grandCost.toFixed(2);


            }
            if (grandCostElement) {
                grandCostElement.value = grandCost.toFixed(2);
            }
            if (discountElement) {
                discountElement.value = discountCost.toFixed(2);
            } else {
                discountCost = 0;
            }

            let grossCost = grandCost - discountCost;
            if (grossElement) {
                grossElement.value = grossCost.toFixed(2);
            } else {
                grossCost = 0;
            }

            let taxCost = (tax / 100) * grossCost;
            if (taxElement) {
                taxElement.value = taxCost.toFixed(2);
            } else {
                taxCost = 0;
            }
            let totalCost = grossCost + taxCost;
            if (totalElement) {
                totalElement.textContent = totalCost.toFixed(2);
            } else {
                totalCost = 0;
            }

            var totalcostInput = row.querySelector('.totalCost-input');
            if (totalcostInput) {
                totalcostInput.value = totalCost.toFixed(2);
            } else {
                totalCost = 0;
            }

            updateTotalCost();
        }


        function updateTotalCost() {
            var taxCostElements = document.querySelectorAll('.taxCost');
            var taxCost = 0;
            var discountCostElements = document.querySelectorAll('.discountCost');
            var discountCost = 0;
            var totalCostElements = document.querySelectorAll('.totalCost');
            var totalGrandCost = 0;
            var totalGrossCostElements = document.querySelectorAll('.GrossCost');
            var totalGrossCost = 0;

            taxCostElements.forEach(function(element) {
                taxCost += parseFloat(element.value) || 0;
            });

            discountCostElements.forEach(function(element) {
                discountCost += parseFloat(element.value) || 0;
            });

            totalCostElements.forEach(function(element) {
                totalGrandCost += parseFloat(element.textContent) || 0;
            });

            totalGrossCostElements.forEach(function(element) {
                totalGrossCost += parseFloat(element.value) || 0;
            });

            var shippingInput = document.querySelector('.ShippingCost');
            var shippingCost = parseFloat(shippingInput.value) || 0;

            var totalGrossElement = document.querySelector('.totalGrossCost-input');
            if (totalGrossElement) {
                totalGrossElement.value = totalGrossCost.toFixed(2);
            }

            var totaltaxElement = document.querySelector('.totalTaxCost');
            if (totaltaxElement) {
                totaltaxElement.textContent = '₹ ' + taxCost.toFixed(2);
                var totaltaxElementInput = document.querySelector('.totalTaxCost-input');
                totaltaxElementInput.value = taxCost.toFixed(2);
            }

            var totalDiscountElement = document.querySelector('.totalDiscountCost');
            if (totalDiscountElement) {
                totalDiscountElement.textContent = '₹ ' + discountCost.toFixed(2);
                var totalDiscountElementInput = document.querySelector('.totalDiscountCost-input');
                totalDiscountElementInput.value = discountCost.toFixed(2);
            }

            // var totalGrandElement = document.querySelector('.totalGrandCost');
            // if (totalGrandElement) {
            //     var grandTotal = shippingCost + totalGrandCost;
            //     totalGrandElement.textContent = '₹ ' + grandTotal.toFixed(2);
            //     var totalGrandElementInput = document.querySelector('.totalGrandCost-input');
            //     totalGrandElementInput.value = grandTotal.toFixed(2);
            // }

            var tcsInput = document.querySelector('.TCSCost');
            var tcsCost = parseFloat(tcsInput.value) || 0;

            var totalGrandElement = document.querySelector('.totalGrandCost');
            if (totalGrandElement) {

                var grandTotal = shippingCost + totalGrandCost;

                var tcsCost1 = (grandTotal * tcsCost) / 100;

                var grandTotal1 = tcsCost1 + grandTotal;

                totalGrandElement.textContent = '₹ ' + grandTotal1.toFixed(2);
                var totalGrandElementInput = document.querySelector('.totalGrandCost-input');
                totalGrandElementInput.value = grandTotal1.toFixed(2);
            }

            var shippingInput = document.querySelector('.ShippingCost');
            if (shippingInput) {
                shippingInput.addEventListener('input', function() {
                    updateTotalCost(); // Call the updateTotalCost function when the input changes
                });
            }
            var tcsInput = document.querySelector('.TCSCost');
            if (tcsInput) {
                tcsInput.addEventListener('input', function() {
                    updateTotalCost(); // Call the updateTotalCost function when the input changes
                });
            }

        }



        var newRows = document.querySelectorAll('.qty-input, .purchase-input, .discount-input, .tax-input , .purchaseList');
        newRows.forEach(function(newRow) {
            newRow.addEventListener('input', function() {
                updateGrandCost(newRow.closest('tr'));
            });
        });


        $(document).ready(function() {

            $('#Ledger').selectize({
                create: true,
                sortField: 'text'
            });


        });
    </script>


    <!-- delete function -->

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.deletebtn').forEach(function(deleteButton) {
                deleteButton.addEventListener('click', function() {
                    // Get the parent row of the delete button
                    var row = deleteButton.closest('tr');
                    // Check if there is only one row in the table
                    if (document.querySelectorAll('table tbody tr').length > 1) {
                        // Reset all input values in the row to zero
                        row.querySelectorAll('input[type="text"]').forEach(function(input) {
                            input.value = "";
                        });

                        // Reset hidden input values in the row to zero
                        row.querySelectorAll('input[type="hidden"]').forEach(function(hiddenInput) {
                            hiddenInput.value = "";
                        });

                        // Update total cost in the row
                        var totalCostCell = row.querySelector('.totalCost');
                        totalCostCell.textContent = "0.00";

                        // Remove the row
                        row.remove();

                        // Update totalTaxCost, totalDiscountCost, ShippingCost, totalGrandCost
                        updateTotalTaxCost();
                        updateTotalDiscountCost();
                        updateShippingCost();
                        updateTotalGrandCost();
                    } else {
                        // Display an alert message if there is only one row
                        alert("You must have at least one row in the table.");
                    }
                });
            });
        });

        // Function to update totalTaxCost
        function updateTotalTaxCost() {
            var totalTaxCostElement = document.querySelector('.totalTaxCost');
            var taxCost = 0;

            // Iterate through all rows and sum up the tax values
            document.querySelectorAll('.taxCost').forEach(function(taxInput) {
                taxCost += parseFloat(taxInput.value) || 0;
            });
            totalTaxCostElement.textContent = '₹ ' + taxCost.toFixed(2);
        }


        function updateTotalDiscountCost() {
            var totalTaxCostElement = document.querySelector('.totalDiscountCost');
            var taxCost = 0;

            // Iterate through all rows and sum up the tax values
            document.querySelectorAll('.discountCost').forEach(function(taxInput) {
                taxCost += parseFloat(taxInput.value) || 0;
            });
            totalTaxCostElement.textContent = '₹ ' + taxCost.toFixed(2);
        }

        function updateTotalGrandCost() {
            var totalGrandElement = document.querySelector('.totalGrandCost');
            var grandCost = 0;

            // Iterate through all rows and sum up the tax values
            // var shippingCostInput = document.querySelector('.ShippingCost');
            //     shippingCostInput.value = "0.00";
            document.querySelectorAll('.totalCost-input').forEach(function(taxInput) {
                grandCost += parseFloat(taxInput.value) || 0;
            });
            totalGrandElement.textContent = '₹ ' + grandCost.toFixed(2);
        }

        // Function to update ShippingCost
        function updateShippingCost() {
            var shippingCostInput = document.querySelector('.ShippingCost');
            shippingCostInput.value = "0.00";
        }

        // // Function to update totalGrandCost
        // function updateTotalGrandCost() {
        //     var totalGrandCostElement = document.querySelector('.totalGrandCost');
        //     totalGrandCostElement.textContent = '₹ 0.00';
        //     // You may want to update related hidden input fields as well
        // }
    </script>

    <!-- set current date -->
    <script>
        // Function to format the current date as DD-MM-YYYY
        function getCurrentDate() {
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0');
            var yyyy = today.getFullYear();
            return dd + '-' + mm + '-' + yyyy;
        }

        // Set default values for datetimepicker inputs
        document.getElementById('referenceDateInput').value = getCurrentDate();
    </script>
    @endsection
</body>

</html>