<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>VMS</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">


    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">


    <!-- FOR EXPORT -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">


        @extends('VMS.navbar')
        @section('content')
        <?php
        $purchaseViews = Session('purchaseViews');
        $purchaseEdit = Session('purchaseEdit');
        $purchaseEntry = Session('purchaseEntry');
        ?>
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Purchase Report</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    @if ($purchaseEntry == "Y" )
                    <div class="page-btn">
                        <a href="purchase" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Purchase</a>

                    </div>
                    @endif
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <!-- <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div> -->
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <!-- <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li> -->
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel" id="toEXCEL"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print" id="print" onclick="printTable()"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="card mb-0" id="filter_inputs">
                            <div class="card-body pb-0">
                                <div class="row">
                                    <div class="col-lg-12 col-sm-12">
                                        <div class="row">
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Choose Product</option>
                                                        <option>Macbook pro</option>
                                                        <option>Orange</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Choose Category</option>
                                                        <option>Computers</option>
                                                        <option>Fruits</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Choose Sub Category</option>
                                                        <option>Computer</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Brand</option>
                                                        <option>N/D</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12 ">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Price</option>
                                                        <option>150.00</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-1 col-sm-6 col-12">
                                                <div class="form-group">
                                                    <a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table  datanew" id="table">
                                <thead>
                                    <tr>


                                        @if ($purchaseViews == "Y" || $purchaseEdit == "Y")
                                        <th>Edit</th>
                                        @endif
                                        <th>PONO</th>
                                        <th>Supplier</th>
                                        <th>PODate</th>
                                        <th>RefNo </th>
                                        <th>RefDate</th>
                                        <th>Gross</th>
                                        <th>Discount</th>
                                        <th>Tax</th>
                                        <th>Net</th>
                                        <th>NetAmt</th>
                                        <th>Remarks</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($decode as $decodes)
                                    <tr>
                                        @if ($purchaseViews == "Y" ||$purchaseEdit == "Y")
                                        <td>


                                            @if ($purchaseViews == "Y")
                                            <a href="purchaseListView?mode=view&Rowid={{ $decodes['Rowid'] }}&pono={{ $decodes['PONO'] }}&RefNo={{ $decodes['RefNo'] }}&RefDate={{ $decodes['RefDate'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&PODate={{ $decodes['PODate'] }}&GrsAmt={{ $decodes['GrsAmt'] }}&DisAmt={{ $decodes['DisAmt'] }}&TaxAmt={{ $decodes['TaxAmt'] }}&Remarks={{ $decodes['Remarks'] }}&TNetAmt={{ $decodes['TNetAmt'] }}&NetAmt={{ $decodes['NetAmt'] }}&TNetAmt={{ $decodes['TNetAmt'] }}&NetAmt={{ $decodes['NetAmt'] }}&Ledger_Address={{ $decodes['Ledger_Address'] }}&GST_No={{ $decodes['GST_No'] }}" class="me-3 viewBtn">
                                                <img src="assets/img/icons/eye.svg" alt="img">
                                            </a>
                                            @endif

                                            @if($decodes['approve_flag'] === "F")

                                            @if ($purchaseEdit == "Y")
                                            <a class="me-5 editBtn" href="purchaseEdit?mode=edit&Rowid={{ $decodes['Rowid'] }}&pono={{ $decodes['PONO'] }}&RefNo={{ $decodes['RefNo'] }}&RefDate={{ $decodes['RefDate'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&PODate={{ $decodes['PODate'] }}&GrsAmt={{ $decodes['GrsAmt'] }}&DisAmt={{ $decodes['DisAmt'] }}&TaxAmt={{ $decodes['TaxAmt'] }}&Remarks={{ $decodes['Remarks'] }}&TNetAmt={{ $decodes['TNetAmt'] }}&NetAmt={{ $decodes['NetAmt'] }}">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            @endif

                                            @endif

                                        </td>
                                        @endif
                                        <td class="productimgname mt-3">

                                            {{$decodes['PONO']}}
                                        </td>
                                        <td>{{$decodes['Ledger_Name']}}</td>
                                        <td>
                                            {{ date('Y-m-d', strtotime($decodes['PODate'])) }}
                                        </td>
                                        <td>{{$decodes['RefNo']}}</td>
                                        <td> {{ date('Y-m-d', strtotime($decodes['RefDate'])) }}</td>
                                        <td>₹.{{$decodes['GrsAmt']}}</td>
                                        <td>₹.{{$decodes['DisAmt']}}</td>
                                        <td>₹.{{$decodes['TaxAmt']}}</td>
                                        <td>₹.{{$decodes['NetAmt']}}</td>
                                        <td>₹.{{$decodes['TNetAmt']}}</td>
                                        <td>{{$decodes['Remarks']}}</td>



                                        <!-- <td>
                                            <form action="purchaseApproval" method="post">
                                                @csrf
                                                <input type="hidden" name="Rowid" value="{{$decodes['Rowid']}}">
                                                <input type="submit" value="submit" class="btn btn-primary">
                                        </td> -->
                                    </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                @if ($message = Session::get('SuccessMsg'))
                <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                    {{$message}}

                </div>

                <script>
                    // Automatically close the alert after 3 seconds
                    setTimeout(function() {
                        var successAlert = document.getElementById('successAlert');
                        if (successAlert) {
                            successAlert.remove();
                        }
                    }, 3000);
                </script>
                @endif
                @if ($message = Session::get('errorMsg'))
                <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
                    {{$message}}

                </div>

                <script>
                    setTimeout(function() {
                        var successAlert = document.getElementById('successAlert');
                        if (successAlert) {
                            successAlert.remove();
                        }
                    }, 3000);
                </script>
                @endif
            </div>
        </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>


    <!-- PRINT -->
    <script>
        function printTable() {
            var printWindow = window.open('', '_blank');
            printWindow.document.write('<html><head><title>Your Table Title</title>');
            printWindow.document.write('</head><body>');

            // Clone the table and remove the first column (Edit column)
            var tableClone = document.getElementById('table').cloneNode(true);
            var rows = tableClone.getElementsByTagName('tr');
            for (var i = 0; i < rows.length; i++) {
                rows[i].removeChild(rows[i].cells[0]); // Remove the first cell in each row
            }

            printWindow.document.write(tableClone.outerHTML);
            printWindow.document.write('</body></html>');
            printWindow.document.close();
            printWindow.print();
        }
    </script>





    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });

            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);

        }

        document.querySelector("#toEXCEL").addEventListener("click", function() {
            var table = document.querySelector("table");
            console.log(table);
            export_table_to_xlsx(table, "Purchase_List.xlsx");
        });
    </script>

    @endsection
</body>

</html>