<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>VMS</title>
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">


    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">


</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Purchase Approve</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                    <div class="page-btn">
                        <a href="purchase" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img" class="me-1">Add New Purchase</a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <!-- <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div> -->

                        <!-- <div class="card mb-0" id="filter_inputs">
                            <div class="card-body pb-0">
                                <div class="row">
                                    <div class="col-lg-12 col-sm-12">
                                        <div class="row">
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Choose Product</option>
                                                        <option>Macbook pro</option>
                                                        <option>Orange</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Choose Category</option>
                                                        <option>Computers</option>
                                                        <option>Fruits</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Choose Sub Category</option>
                                                        <option>Computer</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Brand</option>
                                                        <option>N/D</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg col-sm-6 col-12 ">
                                                <div class="form-group">
                                                    <select class="select">
                                                        <option>Price</option>
                                                        <option>150.00</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-1 col-sm-6 col-12">
                                                <div class="form-group">
                                                    <a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> -->

                        <div class="table-responsive">
                            <table class="table  datanew">
                                <thead>
                                    <tr>
                                        <th>View</th>
                                        <th>Approve</th>
                                        <th>PONO</th>
                                        <th>Supplier</th>
                                        <th>PODate</th>
                                        <th>RefNo </th>
                                        <th>RefDate</th>
                                        <th>Grsoss</th>
                                        <th>Discount</th>
                                        <th>Tax</th>
                                        <!-- <th>Net Amount</th> -->
                                        <th>NetAmt</th>
                                        <!-- <th>Remarks</th> -->


                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($decode as $decodes)
                                    <tr>

                                        <td>
                                            <a href="purchaseListView?mode=view&Rowid={{ $decodes['Rowid'] }}&pono={{ $decodes['PONO'] }}&RefNo={{ $decodes['RefNo'] }}&RefDate={{ $decodes['RefDate'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&PODate={{ $decodes['PODate'] }}&GrsAmt={{ $decodes['GrsAmt'] }}&DisAmt={{ $decodes['DisAmt'] }}&TaxAmt={{ $decodes['TaxAmt'] }}&Remarks={{ $decodes['Remarks'] }}&TNetAmt={{ $decodes['TNetAmt'] }}&NetAmt={{ $decodes['NetAmt'] }}&TNetAmt={{ $decodes['TNetAmt'] }}&NetAmt={{ $decodes['NetAmt'] }}&Ledger_Address={{ $decodes['Ledger_Address'] }}&GST_No={{ $decodes['GST_No'] }}" class="me-3 viewBtn">
                                                <img src="assets/img/icons/eye.svg" alt="img">
                                            </a>

                                            <!-- <a class="me-3" href="purchaseEdit?pono={{ $decodes['PONO'] }}&Ledger_Name={{ $decodes['Ledger_Name'] }}&PODate={{ $decodes['PODate'] }}&GrsAmt={{ $decodes['GrsAmt'] }}&DisAmt={{ $decodes['DisAmt'] }}&TaxAmt={{ $decodes['TaxAmt'] }}&Remarks={{ $decodes['Remarks'] }}&TNetAmt={{ $decodes['TNetAmt'] }}&NetAmt={{ $decodes['NetAmt'] }}">

                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a> -->


                                        </td>
                                        <td>
                                            <form action="purchaseApproval" method="post">
                                                @csrf
                                                <input type="hidden" name="Rowid" value="{{$decodes['Rowid']}}">
                                                <input type="submit" value="Approve" class="btn btn-primary">
                                        </td>
                                        <td class="productimgname mt-3">
                                            {{$decodes['PONO']}}
                                        </td>
                                        <td>{{$decodes['Ledger_Name']}}</td>
                                        <td>
                                            {{ date('Y-m-d', strtotime($decodes['PODate'])) }}
                                        </td>
                                        <td>{{$decodes['RefNo']}}</td>
                                        <td> {{ date('Y-m-d', strtotime($decodes['RefDate'])) }}</td>
                                        <td>₹.{{$decodes['GrsAmt']}}</td>
                                        <td>₹.{{$decodes['DisAmt']}}</td>
                                        <td>₹.{{$decodes['TaxAmt']}}</td>
                                        <!-- <td>{{$decodes['NetAmt']}}</td> -->
                                        <td>₹.{{$decodes['TNetAmt']}}</td>
                                        <!-- <td>{{$decodes['Remarks']}}</td> -->

                                    </tr>
                                    </form>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- respose message -->



    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}

    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif


    <!-- respose message End-->

    <script src="assets/js/jquery-3.6.0.min.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script>
        dataTableInstance.destroy();
        $('#DataTables_Table_0').DataTable();
    </script>
    @endsection
</body>

</html>