<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <title>VMS Demo Video </title>
    <!-- <link rel="icon" href="gplogofinal.png" type="png"> -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">

    <style>
        #newRowTemplate td {
            width: 1.5%;
            padding: 8px;

        }

        #newRowTemplate .custom-form-group {
            margin-bottom: 0;
        }

        #newRowTemplate input {
            width: 10%;
        }

        #newRowTemplate select {
            width: 100%;
        }

        td .selectize-input {
            width: 180px !important;
            /* Adjust the width as needed */
            max-width: 90% !important;
            height: 28px !important;
            margin-right: -50px !important;
        }
    </style>

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">
        @extends('VMS.navbar')
        @section('content')
        <div class="page-wrapper">


            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>Demo Video</h4>
                        <!-- <h6>Add Purchase</h6> -->
                    </div>
                </div>
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                    @if($filteredDetails && count($filteredDetails) > 0)
                    @foreach($filteredDetails as $index => $det)
                    <video width="1200" height="550" controls>
                        <source src="{{ asset('Demo_videos/' . $det['Video_upload']) }}" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                    @endforeach
                    @else
                    NO VIDEO IS UPLOADED
                    @endif
                </div>

            </div>
        </div>
    </div>
    </div>
    </div>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>
    <script src="assets/js/invoice/addInvoice.js"></script>



    @endsection
</body>

</html>