<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="POS - Bootstrap Admin Template">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
    <meta name="author" content="Dreamguys - Bootstrap Admin Template">
    <meta name="robots" content="noindex, nofollow">
    <title>VEHICLE REPORT 2</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- FOR EXPORT -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>

    <style>
        .approveBtn {
            width: 50px;
        }
    </style>

</head>

<body>
    <div id="global-loader">
        <div class="whirly-loader"> </div>
    </div>

    <div class="main-wrapper">

        @extends('VMS.navbar')
        <?php
        $VehicleApprovalApprove = Session('VehicleApprovalApprove');
        $VehicleApprovalViews = Session('VehicleApprovalViews');
        ?>
        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>VEHICLE APPROVE REPORT</h4>
                        <!-- <h6>Manage your products</h6> -->
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datanew" id="table">
                                <thead>
                                     <tr>
                                        <th>Sno</th>
                                        @if ($VehicleApprovalApprove == "Y" || $VehicleApprovalViews == "Y")
                                        <th>Options</th>
                                        @endif
                                        <th style="display: none;">Rowid</th>
                                        <th>Vehicle No</th>
                                        <!-- <th>Vehicle Name</th> -->
                                        <th>Category</th>
                                        <th>Type</th>
                                        <th>Place</th>
                                        <th>Seat</th>
                                        <!-- <th>Capacity</th> -->
                                        <!-- <th>Mileage</th> -->
                                        <th>Company Name</th>
                                        <th>Rent</th>
                                        <th>Owner Name</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($result as $index => $row)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        @if ($VehicleApprovalApprove == "Y" || $VehicleApprovalViews == "Y")
                                        <td>
                                            <div class="action-buttons" style="align-items: center;">
                                                @if ($VehicleApprovalViews == "Y")
                                                <a class="me-3" href="{{ url('Vehicle_App_Report', ['Rowid' => $row['vehcode']]) }}">
                                                    <img src="assets/img/icons/eye.svg" alt="View">
                                                </a>
                                                @endif
                                                @if ($VehicleApprovalApprove == "Y")
                                                <form action="{{ route('vehicle_lv2') }}" id="ApproveForm" method="post">
                                                    @csrf
                                                    <input type="hidden" name="vehcode" value="{{$row['vehcode']}}">
                                                    <button class="btn btn-primary approveBtn" type="submit">App</button>
                                                </form>
                                                @endif
                                            </div>
                                        </td>
                                        @endif
                                        <td style="display: none;">{{ $row['vehcode'] }}</td>
                                        <td>{{ $row['vehno'] }}</td>
                                        <!-- <td>{{ $row['vehname'] }}</td> -->
                                        <td>{{ $row['VehicleCategory'] }}</td>
                                        <td>{{ $row['VTYPE'] }}</td>
                                        <td>{{ $row['PLACE'] }}</td>
                                        <td>{{ $row['seat'] }}</td>
                                        <!-- <td>{{ $row['capacity'] }}</td> -->
                                        <!-- <td>{{ $row['mileage'] }}</td> -->
                                        <td>{{ $row['CompName'] }}</td>
                                        <td>{{ $row['RENT'] }}</td>
                                        <td>{{ $row['OWn_Name'] }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/jquery.slimscroll.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/plugins/select2/js/select2.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>
    <script src="assets/js/script.js"></script>


    <!-- POP UP FOR APPROVE CONFIRMATION -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var form = document.getElementById('ApproveForm');

            form.addEventListener('submit', function(event) {
                var submitBtn = event.submitter;
                if (submitBtn && submitBtn.classList.contains('approveBtn')) {
                    if (!confirm('Are you sure want to approve this entry?')) {
                        event.preventDefault();
                    }
                }
            });
        });
    </script>

    <!-- PRINT -->
    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>

    <!-- EXPORT AS EXCEL -->
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });

            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);

        }

        document.querySelector("#toEXCEL").addEventListener("click", function() {
            var table = document.querySelector("table");
            export_table_to_xlsx(table, "Vehicle_Approval_Report.xlsx");
        });
    </script>


    @if ($message = Session::get('SuccessMsg'))
    <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>

    <script>
        // Automatically close the alert after 3 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 3000);
    </script>
    @endif
    @if ($message = Session::get('errorMsg'))
    <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
        {{$message}}
    </div>
    <script>
        setTimeout(function() {
            var successAlert = document.getElementById('successAlert');
            if (successAlert) {
                successAlert.remove();
            }
        }, 20000);
    </script>
    @endif


</body>

</html>