<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="VMS - Vehicle Management System ">
    <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">

    <title>Diesel Report</title>

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <link rel="stylesheet" href="assets/css/animate.css">

    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">

    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/selectize.css">


</head>

<body>


    <div id="global-loader">
        <div class="whirly-loader"></div>
    </div>

    <div class="page-wrapper">
        @extends('VMS.navbar')
        <div class="content">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        @if ($message = Session::get('success'))
                        <div id="success-alert" class="alert alert-success">
                            <p>{{ $message }}</p>
                        </div>
                        @endif

                        @if(session('alert'))
                        <style>
                            .custom-light-red-alert {
                                background-color: #ffcccc;
                                /* Light Red Color */
                                border-color: #ff9999;
                                /* Border Color */
                                color: #0b0b10;
                                /* Text Color */
                            }
                        </style>

                        <svg xmlns="http://www.w3.org/2000/svg" class="d-none">
                            <symbol id="exclamation-triangle-fill" viewBox="0 0 16 16">
                                <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                            </symbol>
                        </svg>

                        <div id="alert-container" class="alert custom-light-red-alert d-flex align-items-center" role="alert">
                            <svg class="bi flex-shrink-0 me-2" role="img" aria-label="Danger:" style="width: 40px; height: 40px;">
                                <use xlink:href="#exclamation-triangle-fill" />
                            </svg>
                            <div class="mr-3"></div>
                            {{ session('alert') }}
                        </div>
                        @endif
                    </div>
                </div>

                <div class="page-header">
                    <div class="page-title">
                        <h4>Diesel Report</h4>
                    </div>

                </div>

                <div class="card">
                    <div class="card-body ">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>



                            <form action="{{ route('diesel_rep') }}" method="post">
                                @csrf <!-- Add this line to include CSRF token for security -->

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form_date">
                                            <label for="from_date">From Date:</label>
                                            <div class='input-group date' id='datetimepicker6'>
                                                <input type='date' class="form-control" id="from_date" name="from_date" value="{{ date('Y-m-01') }}">
                                                <span class="input-group-addon">
                                                    <span class="glyphicon glyphicon-calendar"></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="to_date">
                                            <label for="to_date">To Date:</label>
                                            <div class='input-group date' id='datetimepicker6'>
                                                <input type='date' class="form-control" id="to_date" name="to_date" value="{{ now()->format('Y-m-d') }}" onchange="updateFromDate()">
                                                <span class="input-group-addon">
                                                    <span class="glyphicon glyphicon-calendar"></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 mt-2 mr-5">
                                        <div class="submit">
                                            <label for="submit"></label> <!-- Empty label for alignment -->
                                            <input type="submit" name="submit" value="Submit" id="saveButton" class="btn btn-primary" style="font-size: 20px; padding: 10px 10px; width:110px;">
                                        </div>
                                    </div>
                                </div>
                            </form>




                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel" id="toEXCEL"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print" id="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>


                        @if(isset($details))
                        <table id="app_table" class="table datanew">
                            <thead class="sticky-header">
                                <tr>
                                    <th>SNO</th>
                                    <th>Vehicle NO</th>
                                    <th>Open KM</th>
                                    <th>Close KM</th>
                                    <th>Total</th>
                                    <th>Used</th>
                                    <th>Mileage</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($details as $index => $row)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $row['ENO'] }}</td>
                                    <td>{{ $row['okm'] }}</td>
                                    <td>{{ $row['ckm'] }}</td>
                                    <td>{{ $row['Total'] }}</td>
                                    <td>{{ $row['Used'] }}</td>
                                    <td>{{ $row['mileage'] }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @else
                        <!-- <p>No data available.</p> -->
                        @endif

                    </div>
                </div>

            </div>
        </div>
    </div>



    <!-- TO_DATE / FROM_DATE DATE ADAPTIVE -->
    <script>
        function updateFromDate() {
            var toDate = document.getElementById("to_date").value;
            var fromDate = toDate.substring(0, toDate.lastIndexOf("-")) + "-01";
            document.getElementById("from_date").value = fromDate;
        }
    </script>


    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/selectize.js"></script>

    <script src="assets/js/feather.min.js"></script>

    <script src="assets/js/jquery.slimscroll.min.js"></script>

    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>

    <script src="assets/js/bootstrap.bundle.min.js"></script>

    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script>

    <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
    <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

    <script src="assets/js/script.js"></script>

    <!-- PRINT -->
    <script>
        document.getElementById('print').addEventListener('click', function() {
            window.print();
        })
    </script>

    <!-- EXPORT AS EXCEL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>
    <script>
        function export_table_to_xlsx(table, filename) {
            var wb = XLSX.utils.table_to_book(table, {
                sheet: "Sheet1"
            });

            var ws = wb.Sheets["Sheet1"];

            // Calculate column widths based on content
            var range = XLSX.utils.decode_range(ws['!ref']);
            for (var C = range.s.c; C <= range.e.c; ++C) {
                var max_len = 0;
                for (var R = range.s.r; R <= range.e.r; ++R) {
                    var cell = ws[XLSX.utils.encode_cell({
                        r: R,
                        c: C
                    })];
                    if (cell && cell.v) {
                        var len = String(cell.v).length;
                        if (len > max_len) {
                            max_len = len;
                        }
                    }
                }
                if (max_len > 0) {
                    ws['!cols'] = ws['!cols'] || [];
                    ws['!cols'][C] = {
                        wch: max_len + 2
                    };
                }
            }

            XLSX.writeFile(wb, filename);
        }

        document.querySelector("#toEXCEL").addEventListener("click", function() {
            var table = document.querySelector("table");
            export_table_to_xlsx(table, "Diesel_report.xlsx");
        });
    </script>

    <script>
        // Hide success message after 10 seconds
        setTimeout(function() {
            var successAlert = document.getElementById('success-alert');
            console.log(successAlert);
            if (successAlert) {
                successAlert.style.display = 'none';
            }
        }, 10000);

        // Hide alert message after 10 seconds
        setTimeout(function() {
            var alertContainer = document.getElementById('alert-container');
            console.log(alertContainer);
            if (alertContainer) {
                alertContainer.style.setProperty('display', 'none', 'important');
            }
        }, 10000);
    </script>

</body>

</html>