<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0" />
  <meta name="description" content="POS - Bootstrap Admin Template" />
  <meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects" />
  <meta name="author" content="Dreamguys - Bootstrap Admin Template" />
  <meta name="robots" content="noindex, nofollow" />
  <title>VMS</title>

  <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png" />
  <link rel="stylesheet" href="assets/css/bootstrap.min.css" />
  <link rel="stylesheet" href="assets/css/animate.css" />
  <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css" />
  <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css" />
  <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css" />
  <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link rel="stylesheet" href="assets/css/selectize.css">

</head>

<body>
  <div id="global-loader">
    <div class="whirly-loader"></div>
  </div>

  <div class="main-wrapper">


    @extends('VMS.navbar')
    @section('content')

    <div class="page-wrapper">
      <div class="content">
        <div class="page-header">
          <div class="page-title">
            <h4>Create Permission</h4>
            <h6>Manage Create Permissions</h6>
            @if ($message = Session::get('SuccessMsg'))
            <div id="successAlert" class="alert alert-success alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
              {{$message}}

            </div>

            <script>
              // Automatically close the alert after 3 seconds
              setTimeout(function() {
                var successAlert = document.getElementById('successAlert');
                if (successAlert) {
                  successAlert.remove();
                }
              }, 3000);
            </script>
            @endif
            @if ($message = Session::get('errorMsg'))
            <div id="successAlert" class="alert alert-danger alert-dismissible fade show fixed-top ms-auto  mt-5 mr-4 " role="alert" style="width:30%; z-index: 9999; ">
              {{$message}}

            </div>

            <script>
              // Automatically close the alert after 3 seconds
              setTimeout(function() {
                var successAlert = document.getElementById('successAlert');
                if (successAlert) {
                  successAlert.remove();
                }
              }, 3000);
            </script>
            @endif

          </div>
        </div>
        <form action="permissionSave" method="post" id="permissionForm">
          @csrf
          <div class="card">
            <div class="card-body">
              <div class="row">
                <div class="col-lg-3 col-sm-12">
                  <div class="form-group">
                    <label>Role</label>
                    <!-- <input type="text" /> -->
                    <select name="role" id="" class="select" required>
                      <option value="">--Select--</option>
                      <option value="Admin">Admin</option>
                      <option value="Employee" selected>Employee</option>
                    </select>
                  </div>
                </div>
                <div class="col-lg-9 col-sm-12">
                  <div class="form-group">
                    <label>Employee Name</label>
                    <select name="EmployeeTno" id="select" class="" required>
                      <option value="">--Select--</option>
                      @foreach ($emplName as $emplNames)
                      <option value="{{$emplNames['Can_person']}}">{{$emplNames['canName']}}/{{$emplNames['canTno']}} </option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-12 mb-3">
                  <div class="input-checkset">
                    <ul>
                      <li>
                        <label class="inputcheck">Select All
                          <input type="checkbox" id="select-all" name="select_all" />
                          <span class="checkmark"></span>
                        </label>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12">
                  <div class="productdetails product-respon">
                    <ul>
                      <li>
                        <h4>Main Menu</h4>
                        <input type="hidden" name="mainMenu" value="Main Menu">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_mainMenu" />
                                <input type="hidden" name="approve_mainMenu_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_mainMenu" />
                                <input type="hidden" name="view_mainMenu_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_mainManu" />
                                <input type="hidden" name="entry_mainManu_hidden" value="N" />
                                <input type="hidden" name="report_mainManu_hidden" value="N" />
                                <input type="hidden" name="edit_mainMenu_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>


                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Dashboard</h4>
                        <input type="hidden" name="dashboard" value="Dashboard">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_dash" id="dashApprove" />
                                <input type="hidden" name="approve_dash_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_dash" id="dashView" />
                                <input type="hidden" name="view_dash_hidden" value="N">

                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_dash" id="dashEdit" />
                                <input type="hidden" name="edit_dash_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_dash" id="dashReport" />
                                <input type="hidden" name="report_dash_hidden" value="N">
                                <input type="hidden" name="entry_dash_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Master Entry</h4>
                        <input type="hidden" name="masterEntry" value="master Entry">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_masterEntry" id="masterApprove" />
                                <input type="hidden" name="approve_masterEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_masterEntry" id="masterView" />
                                <input type="hidden" name="view_masterEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_masterEntry" id="masterEdit" />
                                <input type="hidden" name="edit_masterEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_masterEntry" id="masterEntry" />
                                <input type="hidden" name="entry_masterEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_masterEntry" />
                                <input type="hidden" name="report_masterEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Product</h4>
                        <input type="hidden" name="product" value="Product">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_product" />
                                <input type="hidden" name="approve_product_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_product" />
                                <input type="hidden" name="view_product_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_product" />
                                <input type="hidden" name="edit_product_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_product" />
                                <input type="hidden" name="entry_product_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_product" />
                                <input type="hidden" name="report_product_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Purchase</h4>
                        <input type="hidden" name="pruchase" value="Purchase">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_purchase" />
                                <input type="hidden" name="approve_purchase_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_purchase" />
                                <input type="hidden" name="view_purchase_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_purchase" />
                                <input type="hidden" name="edit_purchase_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_purchase" />
                                <input type="hidden" name="entry_purchase_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_purchase" />
                                <input type="hidden" name="report_purchase_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Grn</h4>
                        <input type="hidden" name="grn" value="Grn">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_grn" />
                                <input type="hidden" name="approve_grn_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_grn" />
                                <input type="hidden" name="view_grn_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_grn" />
                                <input type="hidden" name="edit_grn_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_grn" />
                                <input type="hidden" name="entry_grn_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_grn" />
                                <input type="hidden" name="report_grn_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Invoice</h4>
                        <input type="hidden" name="invoice" value="Invoice">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_invoice" />
                                <input type="hidden" name="approve_invoice_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_invoice" />
                                <input type="hidden" name="view_invoice_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_invoice" />
                                <input type="hidden" name="edit_invoice_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_invoice" />
                                <input type="hidden" name="entry_invoice_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_invoice" />
                                <input type="hidden" name="report_invoice_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Issue Entry</h4>
                        <input type="hidden" name="issueEntry" value="Issue Entry">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_issueEntry" />
                                <input type="hidden" name="approve_issueEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_issueEntry" />
                                <input type="hidden" name="view_issueEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_issueEntry" />
                                <input type="hidden" name="edit_issueEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_issueEntry" />
                                <input type="hidden" name="entry_issueEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_issueEntry" />
                                <input type="hidden" name="report_issueEntry_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Outside Services</h4>
                        <input type="hidden" name="outsideService" value="Outside Service">
                        <div class="input-checkset">
                          <ul>
                            <li>
                              <label class="inputcheck">Approve
                                <input type="checkbox" name="approve_outsideService" />
                                <input type="hidden" name="approve_outsideService_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">View
                                <input type="checkbox" name="view_outsideService" />
                                <input type="hidden" name="view_outsideService_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                            <li>
                              <label class="inputcheck">Edit
                                <input type="checkbox" name="edit_outsideService" />
                                <input type="hidden" name="edit_outsideService_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Entry
                                <input type="checkbox" name="entry_outsideService" />
                                <input type="hidden" name="entry_outsideService_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>
                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_outsideService" />
                                <input type="hidden" name="report_outsideService_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                      <li>
                        <h4>Vehicle Report</h4>
                        <input type="hidden" name="vehicleReport" value="Vehicle Report">
                        <div class="input-checkset">
                          <ul>

                            <li>
                              <label class="inputcheck">Report
                                <input type="checkbox" name="report_vehicleReport" />
                                <input type="hidden" name="approve_vehicleReport_hidden" value="N">
                                <input type="hidden" name="view_vehicleReport_hidden" value="N">
                                <input type="hidden" name="edit_vehicleReport_hidden" value="N">
                                <input type="hidden" name="entry_vehicleReport_hidden" value="N">
                                <input type="hidden" name="report_vehicleReport_hidden" value="N">
                                <span class="checkmark"></span>
                              </label>
                            </li>

                          </ul>
                        </div>
                      </li>
                    </ul>
                    <div class="row">
                      <div class="col-lg-12">
                        <div class="d-md-flex justify-content-center mt-3">
                          <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </form>

      </div>
    </div>
  </div>

  <script src="assets/js/jquery-3.6.0.min.js"></script>

  <script src="assets/js/feather.min.js"></script>

  <script src="assets/js/jquery.slimscroll.min.js"></script>

  <script src="assets/js/jquery.dataTables.min.js"></script>
  <script src="assets/js/dataTables.bootstrap4.min.js"></script>

  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <script src="assets/plugins/select2/js/select2.min.js"></script>

  <script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
  <script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>

  <script src="assets/js/script.js"></script>
  <script src="assets/js/selectize.js"></script>

  <script>
    $(document).ready(function() {
      // Function to handle select change
      $('#select').on('change', function() {
        var emplno = $(this).val(); // Get the selected value

        $.ajax({
          url: "{{ route('permissionShow') }}",
          type: "GET",
          data: {
            emplno: emplno
          },
          dataType: 'json',
          success: function(response) {
            

            let datas = response;

            $(' input[type="checkbox"]').prop('checked', false);

            for (let i = 0; i < datas.length; i++) {
              const menuName = datas[i]["menuName"];

              const entry = datas[i]["entry"];
              const Approve = datas[i]["Approve"];
              const report = datas[i]["report"];
              const Edit = datas[i]["Edit"];
              const Views = datas[i]["Views"];

              if (menuName == "VMS Admin") {
                $(' input[type="checkbox"]').prop('checked', true);
              }

              if (menuName === "Dashboard") {



                $('input[name="approve_dash"]').prop('checked', Approve === "Y");
                $('input[name="view_dash"]').prop('checked', report === "Y");
                $('input[name="edit_dash"]').prop('checked', Edit === "Y");
                $('input[name="report_dash"]').prop('checked', Views === "Y");

              }
              if (menuName === "master Entry") {

                $('input[name="approve_masterEntry"]').prop('checked', Approve === "Y");
                $('input[name="view_masterEntry"]').prop('checked', Views === "Y");
                $('input[name="edit_masterEntry_hidden"]').prop('checked', Edit === "Y");
                $('input[name="entry_masterEntry"]').prop('checked', entry === "Y");
                $('input[name="report_masterEntry"]').prop('checked', report === "Y");

              }
              if (menuName === "Product") {

                $('input[name="approve_product"]').prop('checked', Approve === "Y");
                $('input[name="view_product"]').prop('checked', Views === "Y");
                $('input[name="edit_product"]').prop('checked', Edit === "Y");
                $('input[name="entry_product"]').prop('checked', entry === "Y");
                $('input[name="report_product"]').prop('checked', report === "Y");

              }
              if (menuName === "Main Menu") {

                $('input[name="approve_mainMenu"]').prop('checked', Approve === "Y");
                $('input[name="view_mainMenu"]').prop('checked', Views === "Y");
                $('input[name="edit_mainManu"]').prop('checked', Edit === "Y");
               

              }
              if (menuName === "Purchase") {

                $('input[name="approve_purchase"]').prop('checked', Approve === "Y");
                $('input[name="view_purchase"]').prop('checked', Views === "Y");
                $('input[name="edit_purchase"]').prop('checked', Edit === "Y");
                $('input[name="entry_purchase"]').prop('checked', entry === "Y");
                $('input[name="report_purchase"]').prop('checked', report === "Y");

              }
              if (menuName === "Grn") {

                $('input[name="approve_grn"]').prop('checked', Approve === "Y");
                $('input[name="view_grn"]').prop('checked', Views === "Y");
                $('input[name="edit_grn"]').prop('checked', Edit === "Y");
                $('input[name="entry_grn"]').prop('checked', entry === "Y");
                $('input[name="report_grn"]').prop('checked', report === "Y");

              }
              if (menuName === "Invoice") {

                $('input[name="approve_invoice"]').prop('checked', Approve === "Y");
                $('input[name="view_invoice"]').prop('checked', Views === "Y");
                $('input[name="edit_invoice"]').prop('checked', Edit === "Y");
                $('input[name="entry_invoice"]').prop('checked', entry === "Y");
                $('input[name="report_invoice"]').prop('checked', report === "Y");

              }
              if (menuName === "Issue Entry") {

                $('input[name="approve_issueEntry"]').prop('checked', Approve === "Y");
                $('input[name="view_issueEntry"]').prop('checked', Views === "Y");
                $('input[name="edit_issueEntry"]').prop('checked', Edit === "Y");
                $('input[name="entry_issueEntry"]').prop('checked', entry === "Y");
                $('input[name="report_issueEntry_hidden"]').prop('checked', report === "Y");

              }
              if (menuName === "Outside Service") {

                $('input[name="approve_outsideService"]').prop('checked', Approve === "Y");
                $('input[name="view_outsideService"]').prop('checked', Views === "Y");
                $('input[name="edit_outsideService"]').prop('checked', Edit === "Y");
                $('input[name="entry_outsideService"]').prop('checked', entry === "Y");
                $('input[name="report_outsideService"]').prop('checked', report === "Y");

              }
              if (menuName === "Vehicle Report") {
              
                $('input[name="report_vehicleReport"]').prop('checked', report === "Y");

              }

            }


          }
        });
      });

      // Initialize Selectize on the select element
      $('#select').selectize({
        create: true,
        sortField: 'text'
      });
    });

    // Event listener for checkboxes
    document.addEventListener('DOMContentLoaded', function() {
      const checkboxes = document.querySelectorAll('input[type="checkbox"]');
      checkboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', function() {
          const hiddenInput = document.querySelector(`input[name="${checkbox.name}_hidden"]`);
          hiddenInput.value = checkbox.checked ? 'Y' : 'N';
        });
      });
    });
  </script>


  @endsection
</body>

</html>