<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Powerbi </title>
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="gplogofinal.png" type="png">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">


    <!-- for icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet">

    <style>
        .navbar {
            background: #13265C;
        }

        .nav-link:hover {
            color: #9ffb00 !important;
        }

        .dropdown-menu.left {
            left: auto;
            right: 0;
        }

        .active {

            border-radius: 10px;
            color: #fff;
            font-weight: 500;
            border: 2px solid white;

        }

        a {
            text-decoration: none;
        }

        .card {
            background-image: linear-gradient(105deg,
                    hsl(240deg 82% 35%) 0%,
                    hsl(244deg 79% 37%) 8%,
                    hsl(248deg 76% 39%) 15%,
                    hsl(253deg 72% 41%) 23%,
                    hsl(257deg 69% 42%) 31%,
                    hsl(261deg 66% 44%) 38%,
                    hsl(265deg 64% 46%) 46%,
                    hsl(270deg 61% 48%) 54%,
                    hsl(274deg 58% 50%) 62%,
                    hsl(278deg 60% 52%) 69%,
                    hsl(282deg 62% 54%) 77%,
                    hsl(286deg 65% 56%) 85%,
                    hsl(291deg 67% 58%) 92%,
                    hsl(295deg 70% 60%) 100%);
            box-shadow: 5px 5px 2px 0px rgba(30, 48, 202, 0.29);
            -webkit-box-shadow: 5px 5px 2px 0px rgba(30, 48, 202, 0.29);
            -moz-box-shadow: 10px 10px 5px 0px rgba(30, 48, 202, 0.29);
        }

        .card:hover {
            background-image: linear-gradient(210deg,
                    hsl(256deg 78% 44%) 0%,
                    hsl(260deg 77% 46%) 21%,
                    hsl(265deg 76% 49%) 30%,
                    hsl(269deg 75% 52%) 39%,
                    hsl(274deg 74% 55%) 46%,
                    hsl(278deg 72% 58%) 54%,
                    hsl(282deg 71% 61%) 61%,
                    hsl(287deg 70% 63%) 69%,
                    hsl(291deg 69% 66%) 79%,
                    hsl(296deg 67% 69%) 100%);

        }

        .letter {
            font-weight: 400;
        }
    </style>
    <!-- script for spinner -->

    <link rel="stylesheet" href="{{ asset('frontend/css/spinner.css')}}">
    <script src="{{ asset('frontend/js/spinner.js')}}"></script>

    <!-- script for spinner end -->

</head>

<body id="body" class="">



    <div id="container" class="spin_container">
        <div id="spinner_divider" class="" aria-hidden="true"></div>
        <p id="load_text" class="" aria-label="Loading" style="display: none;">
            <span class="" id="l_1" aria-hidden="true">G</span>
            <span class="" id="l_2" aria-hidden="true">a</span>
            <span class="" id="l_3" aria-hidden="true">i</span>
            <span class="" id="l_4" aria-hidden="true">n</span>
            <span class="" id="l_5" aria-hidden="true">u</span>
            <span class="" id="l_6" aria-hidden="true">p</span>
            <!-- <span class="letter" id="l_3" aria-hidden="true">g</span> -->
        </p>
    </div>


    <div class="container-fulid" id="wrapper">
        @extends('newNavbar')
        @section('content')

        @if (!isset($AccessDenied) )
        <div class="container">
            <div class="row  pt-3 ">
                @foreach ($powerBi as $report)
                <div class="col-xl-3  d-flex justify-content-between">
                    <a href="{{ $report['Link'] }}" >
                        <div class="card button mb-2 ">
                            <div class="card-body text-center text-uppercase text-white h5 p-3">
                                {{ $report['Report_Name'] }}
                                <input type="hidden" value="{{ $report['Link'] }}" id="link">
                            </div>
                        </div>
                    </a>                                       
                </div>
                @endforeach
            </div>
        </div>

    </div>
    @else
    <h1 class="m-5"> {{$AccessDenied}}.</h1>
    @endif

    <script>
        function redirectToAttendance() {
            var link = $('#link').val(); // Get the selected date
            console.log(link);
            if (link) {

                window.location.href = "{{ route('pBi_report') }}?link=" + link;
            }

            event.preventDefault();
        }
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    @endsection

</body>

</html>