<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Connection Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background-color: #f0f0f0;
        }
        h1 {
            color: {{ strpos($status, 'succeeded') !== false ? '#28a745' : '#dc3545' }};
            font-size: 2em;
            text-align: center;
            margin-bottom: 10px;
        }
        p {
            font-size: 1.2em;
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        table {
            border-collapse: collapse;
            width: 80%;
            max-width: 1200px;
            background-color: #fff;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 0.9em;
        }
        th {
            background-color: #f4f4f4;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
    </style>
</head>
<body>
    <h1>{{ $status }}</h1>
    <p>Execution Time: {{ $executionTime }} seconds | Records Generated: {{ count($data) }}</p>
    @if(!empty($data))
        <table>
            <thead>
                <tr>
                    <th>Buyer</th>
                    <th>Merch</th>
                    <th>Emplno</th>
                    <th>EmpCode</th>
                    <th>Merchandiser ID</th>
                    <th>Order No</th>
                    <th>Order Date</th>
                    <th>Ship Date</th>
                    <th>Order Status</th>
                    <th>TA Status</th>
                    <th>Budget</th>
                    <th>Order Qty</th>
                    <th>Shipped Qty</th>
                    <th>BOM Qty</th>
                    <th>Style</th>
                    <th>Garment Price</th>
                    <th>Order Value</th>
                    <th>Buyer Ref No</th>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $item)
                    <tr>
                        <td>{{ $item['Buyer'] ?? '-' }}</td>
                        <td>{{ $item['Merch'] ?? '-' }}</td>
                        <td>{{ $item['Emplno'] ?? '-' }}</td>
                        <td>{{ $item['EmpCode'] ?? '-' }}</td>
                        <td>{{ $item['merchandiserid'] ?? '-' }}</td>
                        <td>{{ $item['Order_No'] ?? '-' }}</td>
                        <td>{{ $item['Order_Date'] ?? '-' }}</td>
                        <td>{{ $item['Ship_Date'] ?? '-' }}</td>
                        <td>{{ $item['Order_Status'] ?? '-' }}</td>
                        <td>{{ $item['TA_Status'] ?? '-' }}</td>
                        <td>{{ $item['Budget'] ?? '-' }}</td>
                        <td>{{ $item['Order_Qty'] ?? '-' }}</td>
                        <td>{{ $item['Shipped_Qty'] ?? '-' }}</td>
                        <td>{{ $item['BOM_Qty'] ?? '-' }}</td>
                        <td>{{ $item['Style'] ?? '-' }}</td>
                        <td>{{ $item['Gar_price'] ?? '-' }}</td>
                        <td>{{ $item['Order_Val'] ?? '-' }}</td>
                        <td>{{ $item['Buyer_Ref_No'] ?? '-' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</body>
</html>