<?php

namespace App\Http\Controllers\LifeAtGainup\Merchandiser;


use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;

class MerchandiserController extends Controller
{

    public function merchandiserdashboard()
        {
            $empId = Session('empl_id');

            
            $countCacheKey = 'dashboard_counts_' . $empId;
            $countData = Cache::remember($countCacheKey, 86400, function () use ($empId) {
                $apiUrl = env('API_URL') . 'dashboard/' . $empId;
                $response = Http::get($apiUrl);
                return [
                    'buyer' => $response['data']['buyer'] ?? 0,
                    'total' => $response['data']['total'] ?? 0,
                ];
            });

            
            $capacityCacheKey = 'capacity_plan_2025';
            $capacityData = Cache::remember($capacityCacheKey, 86400, function () {
                $response = Http::get(env('API_URL') . 'capacityplan/2025');
                $decoded = json_decode($response->body(), true);
                return [
                    'CapBookMis' => $decoded['data']['CapBookMis'] ?? [],
                    'CapBookQty' => $decoded['data']['CapBookQty'] ?? [],
                ];
            });

            
            $buyerCnt = $countData['buyer'];
            $Ocntotal = $countData['total'];
            $capacityMinsArr = $capacityData['CapBookMis'];
            $capacityQtyArr = $capacityData['CapBookQty'];

            
            return view('LifeAtGainup.Merchandiser.merchandiser', compact('buyerCnt', 'Ocntotal', 'capacityMinsArr', 'capacityQtyArr'));
        }

    public function mddashboard(Request $request)
    {
        $empId = Session('empl_id');

        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');

        $apiUrl = env('API_URL') . 'alldashboard/' . $empId . '?start_date=' . $startDate . '&end_date=' . $endDate;

        $response = Http::get($apiUrl);
        $dataaa = $response->json();
      //  dd($dataaa);

        if ($request->ajax()) {
            return response()->json($dataaa);
        }

        return view('LifeAtGainup.Merchandiser.merchandiser', [
            'mddata' => $dataaa
        ]);
    }


    public function merchandiserorderbeta(Request $request)
    {
        // Fetch all the data from the API
	
        $inputdata = $request->input();
        if (empty($inputdata)) {
            $inputdata = [
                'emp_id' => Session('empl_id'),
                'order_status' => 'N',
                
                
            ];  
        }
        // Fetch all the data from the API
        $response = Http::get(env('API_URL').'merchandiser',$inputdata);
        //dd($response);
        $res_set = json_decode($response, true);
        $result = $res_set['data'];

        // Collect all buyers (before filtering) for the dropdown
        $allBuyers = collect($result)->pluck('buyer')->unique();
        $uniquePO = collect($result)->pluck('buyer_po')->unique();

        // On initial page load, filter by order_status = 'N' if no status is selected
        if (!$request->has('order_status') || $request->input('order_status') == 'N') {
            $result = array_filter($result, function ($item) {
                return $item['order_status'] === 'N';
            });
        }

        // Apply other filters if present
        if ($request->filled('buyer_name')) {
            $buyerName = $request->input('buyer_name');
            $result = array_filter($result, function ($item) use ($buyerName) {
                return $item['buyer'] === $buyerName;
            });
        }
        if ($request->filled('file_status')) {
            $file_status = $request->input('file_status');
            $result = array_filter($result, function ($item) use ($file_status) {
                return $item['file_status'] === $file_status;
            });
        }

        if ($request->filled('uniquePO')) {
            $uniquePO = $request->input('uniquePO');
            $result = array_filter($result, function ($item) use ($uniquePO) {
                return $item['buyer_po'] === $uniquePO;
            });
        }

        if ($request->filled('ocn_no')) {
            $ocn_no = $request->input('ocn_no');
            $result = array_filter($result, function ($item) use ($ocn_no) {
                return $item['order_no'] === $ocn_no;
            });
        }

        if ($request->filled('order_status')) {
            $orderStatus = $request->input('order_status');
            if ($orderStatus != 'all') {
                $result = array_filter($result, function ($item) use ($orderStatus) {
                    return $item['order_status'] === $orderStatus;
                });
            }else{
               $orderStatus = 'N' ;
            }
        }

        // Return the filtered data and all unique buyers
        if ($request->ajax()) {
            return response()->json([
                'result' => $result,
                'allBuyers' => $allBuyers, // Send all buyers to the frontend
            ]);
        }

        // Render the view with all unique buyers
        return view('LifeAtGainup.Merchandiser.merchandiserorder', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);
    }

    public function merchandiserorder(Request $request)
    {
        $inputdata = $request->input();
    
        if (empty($inputdata)) {
            $inputdata = [
                'emp_id' => Session('empl_id'),
                'order_status' => 'N',
            ];
        }
    
        // 🔑 Create a unique cache key based on employee and query params
        $cacheKey = 'merch_order_' . Session('empl_id') . '_' . md5(json_encode($inputdata));
    
        try {
            // ⚡ Cache the API response for 1 day (86400 seconds)
            $res_set = Cache::remember($cacheKey, 86400, function () use ($inputdata) {
                $response = Http::get(env('API_URL') . 'merchandiser', $inputdata);
                if ($response->successful()) {
                    return json_decode($response, true);
                } else {
                    Log::error('Merchandiser API Error: ' . $response->body());
                    return ['data' => []];
                }
            });
    
            $result = $res_set['data'] ?? [];
    
            // 👕 Extract unique values for filters
            $allBuyers = collect($result)->pluck('buyer')->unique();
            $uniquePO = collect($result)->pluck('buyer_po')->unique();
    
            // 🧹 Filters (as usual)
            if (!$request->has('order_status') || $request->input('order_status') == 'N') {
                $result = array_filter($result, fn($item) => $item['order_status'] === 'N');
            }
    
            if ($request->filled('buyer_name')) {
                $buyerName = $request->input('buyer_name');
                $result = array_filter($result, fn($item) => $item['buyer'] === $buyerName);
            }
    
            if ($request->filled('file_status')) {
                $file_status = $request->input('file_status');
                $result = array_filter($result, fn($item) => $item['file_status'] === $file_status);
            }
    
            if ($request->filled('uniquePO')) {
                $po = $request->input('uniquePO');
                $result = array_filter($result, fn($item) => $item['buyer_po'] === $po);
            }
    
            if ($request->filled('ocn_no')) {
                $ocn_no = $request->input('ocn_no');
                $result = array_filter($result, fn($item) => $item['order_no'] === $ocn_no);
            }
    
            if ($request->filled('order_status')) {
                $orderStatus = $request->input('order_status');
                if ($orderStatus !== 'all') {
                    $result = array_filter($result, fn($item) => $item['order_status'] === $orderStatus);
                }
            }
    
            // ⚡ If it's AJAX, return JSON
            if ($request->ajax()) {
                return response()->json([
                    'result' => array_values($result), // reindex after filtering
                    'allBuyers' => $allBuyers,
                ]);
            }
    
            // 🖥️ Else render full view
            return view('LifeAtGainup.Merchandiser.merchandiserorderbeta1', [
                'uniqueBuyers' => $allBuyers,
                'uniquePO' => $uniquePO,
            ]);
    
        } catch (\Exception $e) {
            Log::error('MerchandiserOrder Controller Error: ' . $e->getMessage());
            return response()->json(['error' => 'Something went wrong, contact support.'], 500);
        }
    }

    public function merchandiserorder_new(Request $request)
    {
        $empId = Session('empl_id');        
        if ($request->ajax()) {
            $input = http_build_query($request->input());
            $cleanedString = str_replace('+', '%20', $input); 
            $apiUrl = env('API_URL') . 'merchandiserbeta/abc=1&' . $cleanedString;
            //dd($apiUrl);
            $response = Http::get($apiUrl);
            $dataaa = $response->json();
            return response()->json($dataaa);
        }
        $allBuyers=[];
        $uniquePO=[];

        // Render the view with all unique buyers
        return view('LifeAtGainup.Merchandiser.merchandiserorderbeta1', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);
    }

    public function optcommonsearch_portal(Request $request)
    {
        $empId = $request->empId;
        $response1 = Http::get(env('API_URL') . 'optcommonsearch' . '/' . $empId);
        $res_set = json_decode($response1, true);
        return response()->json($res_set);
    }



    public function getOcnByBuyer(Request $request)
    {
        $buyerName = $request->input('buyer_name');
        $orderStatus = $request->input('order_status');
        $file_Status = $request->input('file_status');

        $inputdata = [
            'emp_id' => Session('empl_id'),
            'order_status' => $orderStatus,
            'buyer_name'    => $buyerName,
            'file_status' => $file_Status,

            
        ]; 

        $response = Http::get(env('API_URL').'merchandiser',$inputdata);
        $res_set = json_decode($response, true);
        $result = $res_set['data'];

        // Filter based on both buyer name and order status
        $ocnNumbers = collect($result)
                        ->when($buyerName, function ($query) use ($buyerName) {
                            return $query->where('buyer', $buyerName);
                        })
                        ->when($orderStatus && $orderStatus !== 'all', function ($query) use ($orderStatus) {
                            return $query->where('order_status', $orderStatus);
                        })
                        ->when($file_Status, function ($query) use ($file_Status) {
                            return $query->where('file_status', $file_Status);
                        })
                        ->pluck('order_no')
                        ->unique();

        return response()->json($ocnNumbers);
    }
//Dashboard log
    public function userlogmerch(Request $request){
        $emp_id = $request->emp_id;
        $response = Http::get(env('API_URL').'userlog'.'/'.$emp_id);
       
            $res_set = json_decode($response, true);

            //dd($res_set);

            return response()->json($res_set);

        
       


    }

    //Layout image

    public function merchlayout(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'merchlayout'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);

    } 

    public function alertinfo(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'alertinfo'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);

    } 


    //time to action popup
    public function timetoaction(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'timetoaction'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    //supplierpo popup
    public function rawmaterialstatus(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'rawmaterialstatus'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

     //budgetstatus popup
     public function budgetstatus(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'budgetstatus'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }


    //production status popup

    public function productstatus(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'productstatus'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }
    public function sizebreakup(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'sizebreakup'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function Process_Po_Summary_Proc(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'processposum'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function Process_Po_Detail_Proc(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'processpoitemdet'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function Process_Po_Summary_Proc_new(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'processposum_new'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
    }

    public function Process_Po_Detail_Proc_new(Request $request){
        $ocno = $request->orderNo;
        $id = $request->id;
        $response = Http::get(env('API_URL').'processpoitemdet_new'.'/'.$ocno.'/'.$id);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
    }
 
    public function buyerpostatus(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'buyerpostatus'.'/'.$ocno);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function buyerpostatussummary(Request $request){
        //$ocno = $request->orderNo;
        $inputdata = $request->input();
        $response = Http::get(env('API_URL').'operationdetailsidwisesummary',$inputdata);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function sizewisepobreakup(Request $request){
        //$ocno = $request->orderNo;
        $inputdata = $request->input();
        $response = Http::get(env('API_URL').'operationdetailsidwisedetails',$inputdata);
       
        $res_set = json_decode($response, true);
         return response()->json($res_set);
 
    }

    public function ooptcommonsearch_portal(Request $request)
    {
        $inputdata = $request->input();
        if (empty($inputdata)) {
            $inputdata = [
                'empId' => $request->empId,
                'portal_id' => 2,             
                
            ];  
        }
        // Fetch all the data from the API
        $response = Http::get(env('API_URL').'optcommonsearch_portal',$inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function merchlistreport(Request $request){
        $ocno = $request->orderNo;
        $response = Http::get(env('API_URL').'merchlistreport'.'/'.$ocno);       
        $res_set = json_decode($response, true);
        return response()->json($res_set); 
    }

    public function viewreportitem(Request $request){
        $ocno = $request->reportid;
        $response = Http::get(env('API_URL').'merchlistreport'.'/'.$ocno);       
        $res_set = json_decode($response, true);
        return response()->json($res_set); 
    }

    public function updatefilterdata(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'updatefilterdata', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }
    public function alertinfo_store(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'alertinfo_store', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function endlinepresentation(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::GET(env('API_URL') . 'endlinepresentation', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function merchandiserorder_portal(Request $request){
        $inputdata = $request->input();
        $response = Http::GET(env('API_URL') . 'Merchandiserorder_portal');
       
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function test_DB(Request $request)
    {
        $startTime = microtime(true);
    
        try {
            // 🟡 1. Get emp_id from session
            $emp_id = session('emp_id'); // make sure it's set in session before
    
            // 🟡 2. Build full URL with query string
            $url = env('API_URL') . 'Merchandiserorder_portal?emp_id=' . $emp_id;
    
            // 🟢 3. Send GET request with emp_id
            $response = Http::get($url);
    
            // 🟢 4. Handle success/failure
            $status = $response->successful()
                ? 'Connection succeeded'
                : 'Connection failed: HTTP ' . $response->status() . ' for URL ' . $url;
    
            $data = $response->successful() ? $response->json()['data'] : [];
    
        } catch (\Exception $e) {
            $status = 'Connection failed: ' . $e->getMessage() . ' for URL ' . $url;
            $data = [];
        }
    
        $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);
    
        return view('test_db', [
            'status' => $status,
            'executionTime' => $executionTime,
            'data' => $data
        ]);
    }
    


    public function test_db_merch (Request $request)
    {
        $empId = Session('empl_id');        
        if ($request->ajax()) {
            $input = http_build_query($request->input());
            $cleanedString = str_replace('+', '%20', $input); 
            $apiUrl = env('API_URL') . 'Merchandiserorder_portal' . $cleanedString;
        dd($apiUrl);
            $response = Http::get($apiUrl);
            $dataaa = $response->json();
            return response()->json($dataaa);
        }
        $allBuyers=[];
        $uniquePO=[];

        // Render the view with all unique buyers
        return view('test_db', [
            'uniqueBuyers' => $allBuyers,'uniquePO' => $uniquePO,
        ]);
    }
}
