<?php

namespace App\Http\Controllers\LifeAtGainup\Merchandiser;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
class MicroplanningController extends Controller{

    public function microplan()
    {
        return view('LifeAtGainup.Planning.Micro_planning');
    }

    public function betamicroplan()
    {
        return view('LifeAtGainup.Planning.betaMicro_planning');
    }

    public function microplanbeta()
    {
        return view('LifeAtGainup.Planning.Micro_planning_beta');
    }
    
    public function microplan1()
    {
        return view('LifeAtGainup.Planning.microbeta');
    }

    public function microplanbeta1()
    {
        return view('LifeAtGainup.Planning.Micro_planning_beta1');
    }

    public function microplaneddata(Request $request){
        $response = Http::get(env('API_URL').'microplaneddata');    //microplan   
        $res_set = json_decode($response, true);
        return response()->json($res_set); 
    }

    public function unitdata(Request $request)
    {
        $response = Http::get(env('API_URL').'unitdata');    //microplan   
        $res_set = json_decode($response, true);
        return response()->json($res_set); 
    }

    public function microplaningfilter(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Get(env('API_URL').'microplaningfilter',$inputdata);
        $result = json_decode($response, true);
        return response()->json([
            'result' => $result,
        ]);
    }

    public function insertOrUpdateMicroPlan(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'insertOrUpdateMicroPlan', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function deleteMicroPlan(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'deleteMicroPlan', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function deleteMicroPlanSingle(Request $request)
    {
        $inputdata = $request->input();
        $response = Http::Post(env('API_URL') . 'deleteMicroPlanSingle', $inputdata);
        $res_set = json_decode($response, true);
        return response()->json($res_set);
    }

    public function ordersummary(Request $request)
    {
        // Format orderno to match original logic
        $orderno = ($request->filled('orderno') && $request->get('orderno') !== 'GIL\\') 
            ?  $request->get('orderno') 
            : null;

        // Prepare input for API request
        $input = ['orderno' => $orderno,
            'itemid' => $request->input('itemid', null), // Optional itemid
            'colorid' => $request->input('colorid', null), // Optional colorid
            'unit_code'=> $request->input('unit_code', null)
    ];

        try {
            // Make HTTP GET request to ordersummary API endpoint
            $response = Http::get(env('API_URL') . 'ordersummary', $input);

            // Check if request was successful
            if (!$response->successful()) {
                    return response()->json(['error' => 'Failed to fetch order summary'], $response->status());
                }

                // Decode JSON response
                $res_set = json_decode($response, true);

                // Validate JSON decoding
                if (json_last_error() !== JSON_ERROR_NONE) {
                    return response()->json(['error' => 'Invalid API response format'], 500);
                }

                // Wrap response to match original sendResponse structure
                return response()->json(['data' => $res_set]);
            } catch (\Exception $e) {
                // Handle any other errors (e.g., network issues)
                return response()->json(['error' => 'An error occurred: ' . $e->getMessage()], 500);
            }
        }


        public function ocnlineplan(Request $request){
            $orderno = $request->input('ocn_no'); // Get order number from request
            $unit_code= $request->input('unit_code');
            // Prepare input for API request
            $input = ['ocn_no' => $orderno,'unit_code' => $unit_code];
            $response = Http::get(env('API_URL').'ocnlineplan',$input);    //microplan   
            $res_set = json_decode($response, true);
            return response()->json($res_set); 
        }


        public function machinedetails(Request $request)
        {
            // Get unit code from request
            $unit = $request->input('unit', null);
    
            // Prepare input for API request
            $input = [
                'unit' => $unit
            ];
    
    
           
    
            try {
                // Make HTTP GET request to machinedetails API endpoint
                $response = Http::get(env('API_URL') . 'machinedetails', $input);
    
                // Check if request was successful
                if (!$response->successful()) {
                    return response()->json(['error' => 'Failed to fetch machine details'], $response->status());
                }
    
                // Decode JSON response
                $res_set = json_decode($response, true);
    
                // Validate JSON decoding
                if (json_last_error() !== JSON_ERROR_NONE) {
                    return response()->json(['error' => 'Invalid API response format'], 500);
                }
    
                // Wrap response to match original sendResponse structure
                return response()->json(['data' => $res_set]);
            } catch (\Exception $e) {
                // Handle any other errors (e.g., network issues)
                return response()->json(['error' => 'An error occurred: ' . $e->getMessage()], 500);
            }
    
        }

        public function updateTailorQuantity(Request $request)
        {
            $inputdata = $request->input();
            $response = Http::Post(env('API_URL') . 'operatorupdate', $inputdata);
            $res_set = json_decode($response, true);
            return response()->json($res_set);
        }

        public function ocnItemlineplan(Request $request){
            $orderno = $request->input('ocn_no');
            $itemid = $request->input('itemid');
            $unit_code = $request->input('unit_code');
            $input = ['ocn_no' => $orderno, 'itemid' => $itemid, 'unit_code' => $unit_code];
            $response = Http::get(env('API_URL').'ocnItemlineplan',$input);  
            $res_set = json_decode($response, true);
            return response()->json($res_set);
        }


        public function allocnsearch()
        {
            $response = Http::get(env('API_URL').'ocnsearch');
            return response()->json($response->json());
        } 
        
        public function plannedvsactual(Request $request)
        {
            $unitCode = $request->query('unit_code'); // Get unit_code from query parameter
            $apiUrl = env('API_URL') . 'plannedvsactual?unit_code=' . urlencode($unitCode); // Append unit_code to API URL
            $response = Http::get($apiUrl);
            return response()->json($response->json());
        }


        public function plandelete(Request $request)
        {
            $inputdata = $request->input();
            $response = Http::get(env('API_URL') . 'plandelete', $inputdata);
            $res_set = json_decode($response, true);
            return response()->json($res_set);
        }

        public function planlogoutUpdate(Request $request)
        {
            $inputdata = $request->input();
            $response = Http::post(env('API_URL') . 'planlogin_update', $inputdata);
            $res_set = json_decode($response, true);
            return response()->json($res_set);
        }

}