// Data management - converted from React state
class PurchaseDataManager {
    constructor() {
        this.allPurchaseData = [];
        this.filteredData = [];
        this.selectedDivision = 'All';
        this.selectedTimeframe = 'Monthly';
        this.generateMockData();
    }

    // Generate mock data (simplified version of your React function)
    generateMockData() {
        const divisionConfig = {
            'Garments': {
                suppliers: ['Laxmi Labels', 'Madras Coats', 'Kumar Textiles', 'Vishnu Fabrics', 'Metro Labels'],
                itemGroups: ['Label', 'Thread', 'Button', 'Zipper', 'Hanger', 'Packaging'],
                customers: ['Takko', 'Reliance', 'Primark', 'H&M', 'Zara', 'Next']
            },
            'Spinning': {
                suppliers: ['Sri Laxmi Cotton Mills', 'Karnataka Cotton', 'Tamil Nadu Cotton Corp'],
                itemGroups: ['Cotton', 'Cotton Yarn', 'Polyester Yarn', 'Viscose Yarn'],
                customers: ['Arvind Mills', 'Vardhman Textiles', 'Welspun India']
            },
            // Add other divisions...
        };

        const mockData = [
            {
                id: 'PO113214',
                poDate: '01/08/2025',
                poType: 'Local',
                supplier: 'Laxmi Labels',
                itemGroup: 'Label',
                poQty: 100,
                poRate: 0.35,
                poVal: 35,
                division: 'Garments',
                purchaseManager: 'Mr.Britto',
                customer: 'Takko',
                supplierAdvancePaid: true,
                advanceAmount: 10.5
            },
            // Add more mock data...
        ];

        // Generate additional data
        for (let i = 0; i < 500; i++) {
            const divisions = Object.keys(divisionConfig);
            const division = divisions[Math.floor(Math.random() * divisions.length)];
            const config = divisionConfig[division];
            
            const supplier = config.suppliers[Math.floor(Math.random() * config.suppliers.length)];
            const itemGroup = config.itemGroups[Math.floor(Math.random() * config.itemGroups.length)];
            const customer = config.customers[Math.floor(Math.random() * config.customers.length)];
            
            const poQty = Math.floor(Math.random() * 1000) + 10;
            const poRate = Math.floor(Math.random() * 100) + 5;
            
            mockData.push({
                id: `PO${113000 + i}`,
                poDate: this.formatDate(new Date(2025, Math.floor(Math.random() * 12), Math.floor(Math.random() * 28) + 1)),
                poType: Math.random() > 0.75 ? 'Import' : 'Local',
                supplier,
                itemGroup,
                poQty,
                poRate,
                poVal: poQty * poRate,
                division,
                purchaseManager: Math.random() > 0.5 ? 'Mr.Britto' : 'Mr.Udhaya',
                customer,
                supplierAdvancePaid: Math.random() > 0.65,
                advanceAmount: Math.random() > 0.65 ? (poQty * poRate * (0.2 + Math.random() * 0.3)) : 0
            });
        }

        this.allPurchaseData = mockData;
        this.filterData();
    }

    formatDate(date) {
        const day = date.getDate().toString().padStart(2, '0');
        const month = (date.getMonth() + 1).toString().padStart(2, '0');
        const year = date.getFullYear();
        return `${day}/${month}/${year}`;
    }

    // Filter data based on selected division
    filterData() {
        this.filteredData = this.selectedDivision === 'All' 
            ? this.allPurchaseData 
            : this.allPurchaseData.filter(item => item.division === this.selectedDivision);
    }

    // Calculate KPIs
    calculateKPIs() {
        const totalOrders = this.filteredData.length;
        const totalValue = this.filteredData.reduce((sum, item) => sum + item.poVal, 0);
        const advancePaymentOrders = this.filteredData.filter(item => item.supplierAdvancePaid).length;
        
        return {
            totalOrders,
            totalValue,
            advancePaymentOrders,
            avgOrderValue: totalValue / totalOrders || 0
        };
    }

    // Get supplier performance data
    getSupplierPerformance() {
        const supplierPerformance = {};
        
        this.filteredData.forEach(item => {
            if (!supplierPerformance[item.supplier]) {
                supplierPerformance[item.supplier] = {
                    name: item.supplier,
                    orders: 0,
                    totalValue: 0
                };
            }
            
            supplierPerformance[item.supplier].orders += 1;
            supplierPerformance[item.supplier].totalValue += item.poVal;
        });
        
        return Object.values(supplierPerformance);
    }

    // Get division breakdown
    getDivisionBreakdown() {
        const divisionData = {};
        
        this.allPurchaseData.forEach(item => {
            if (!divisionData[item.division]) {
                divisionData[item.division] = { name: item.division, value: 0, orders: 0 };
            }
            divisionData[item.division].value += item.poVal;
            divisionData[item.division].orders += 1;
        });
        
        return Object.values(divisionData);
    }

    // Set division filter
    setDivision(division) {
        this.selectedDivision = division;
        this.filterData();
    }
}

// Global instance
window.purchaseData = new PurchaseDataManager();